/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl.processors.request;

import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.impl.SoapMessage;
import com.vmware.vim.sso.client.impl.Util;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import com.vmware.vim.sso.client.impl.processors.request.AcquireTokenRequestBuilder;
import com.vmware.vim.sso.client.util.codec.Base64;
import javax.xml.bind.JAXBContext;
import org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SecurityHeaderType;

public final class InitiateAcquireTokenByGssRequestBuilder
extends AcquireTokenRequestBuilder {
    private final byte[] _leg;
    private final String _contextId;

    public InitiateAcquireTokenByGssRequestBuilder(TokenSpec tokenSpec, byte[] initialLeg, boolean hokConfirmation, JAXBContext jaxbContext, int requestValidityInSeconds) {
        super(tokenSpec, hokConfirmation, jaxbContext, requestValidityInSeconds);
        assert (initialLeg != null);
        this._leg = initialLeg;
        this._contextId = Util.randomNCNameUUID();
    }

    @Override
    protected void addRequestData(RequestSecurityTokenType request, ObjectFactory wstFactory) {
        request.setContext("urn:" + this._contextId);
        request.setBinaryExchange(this.createBinaryExchangeElement(wstFactory, this._leg));
    }

    @Override
    protected void addSecurityHeaderInfo(SecurityHeaderType header) {
    }

    @Override
    protected void postProcessAcquireRequest(SoapMessage message) throws ParserException {
    }

    @Override
    protected String createRedactedDescription() {
        return String.format("%s [leg=%s, contextId=%s]", this.getClass().getSimpleName(), Base64.encodeBase64String(this._leg), this._contextId);
    }
}

