/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.impl.util;

import com.vmware.vim.binding.impl.vmodl.BinaryImpl;
import com.vmware.vim.binding.sso.admin.PasswordFormat;
import com.vmware.vim.binding.sso.admin.PrincipalDiscoveryService;
import com.vmware.vim.binding.vmodl.Binary;
import com.vmware.vim.sso.AboutInfo;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.ExternalDomainDetails;
import com.vmware.vim.sso.admin.Group;
import com.vmware.vim.sso.admin.GroupDetails;
import com.vmware.vim.sso.admin.LockoutPolicy;
import com.vmware.vim.sso.admin.PasswordExpirationConfig;
import com.vmware.vim.sso.admin.PasswordFormat;
import com.vmware.vim.sso.admin.PasswordPolicy;
import com.vmware.vim.sso.admin.PersonDetails;
import com.vmware.vim.sso.admin.PersonUser;
import com.vmware.vim.sso.admin.PrincipalDiscovery;
import com.vmware.vim.sso.admin.SmtpConfig;
import com.vmware.vim.sso.admin.SolutionDetails;
import com.vmware.vim.sso.admin.util.CertificateUtil;
import com.vmware.vim.sso.client.util.codec.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;

public final class VmodlTypeConversions {
    private VmodlTypeConversions() {
    }

    public static com.vmware.vim.binding.sso.PrincipalId toVmodl(PrincipalId data) {
        com.vmware.vim.binding.sso.PrincipalId vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.PrincipalId(data.getName(), data.getDomain());
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.PrincipalId[] toVmodl(PrincipalId[] data) {
        com.vmware.vim.binding.sso.PrincipalId[] vmodlData = null;
        if (data != null) {
            int size = data.length;
            vmodlData = new com.vmware.vim.binding.sso.PrincipalId[size];
            for (int i = 0; i < size; ++i) {
                vmodlData[i] = VmodlTypeConversions.toVmodl(data[i]);
            }
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.admin.GroupDetails toVmodl(GroupDetails data) {
        com.vmware.vim.binding.sso.admin.GroupDetails vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.GroupDetails(data.getDescription());
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.admin.PersonDetails toVmodl(PersonDetails data) {
        com.vmware.vim.binding.sso.admin.PersonDetails vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.PersonDetails(data.getDescription(), data.getEmailAddress(), data.getFirstName(), data.getLastName());
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.admin.SolutionDetails toVmodl(SolutionDetails data) {
        com.vmware.vim.binding.sso.admin.SolutionDetails vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.SolutionDetails(data.getDescription(), VmodlTypeConversions.certificateToVmodl(data.getCertificate()));
        }
        return vmodlData;
    }

    public static PrincipalDiscoveryService.SearchCriteria toVmodl(PrincipalDiscovery.SearchCriteria data) {
        PrincipalDiscoveryService.SearchCriteria vmodlData = null;
        if (data != null) {
            vmodlData = new PrincipalDiscoveryService.SearchCriteria(data.getSearchString(), data.getDomain());
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.admin.SmtpConfig toVmodl(SmtpConfig data) {
        com.vmware.vim.binding.sso.admin.SmtpConfig result = null;
        if (data != null) {
            String host = data.getHost();
            int port = data.getPort();
            boolean authenticate = data.isAuthenticate();
            String user = data.getUser();
            String password = data.getPassword() != null ? new String(data.getPassword()) : null;
            result = new com.vmware.vim.binding.sso.admin.SmtpConfig(host, Integer.valueOf(port), Boolean.valueOf(authenticate), user, password);
        }
        return result;
    }

    private static PasswordFormat.LengthRestriction fromVmodl(PasswordFormat.LengthRestriction vmodlData) {
        PasswordFormat.LengthRestriction data = null;
        if (vmodlData != null) {
            data = new PasswordFormat.LengthRestriction(vmodlData.getMinLength(), vmodlData.getMaxLength());
        }
        return data;
    }

    private static PasswordFormat.LengthRestriction toVmodl(PasswordFormat.LengthRestriction data) {
        PasswordFormat.LengthRestriction vmodlData = null;
        if (data != null) {
            vmodlData = new PasswordFormat.LengthRestriction(data.getMinLength(), data.getMaxLength());
        }
        return vmodlData;
    }

    private static PasswordFormat.AlphabeticRestriction fromVmodl(PasswordFormat.AlphabeticRestriction vmodlData) {
        PasswordFormat.AlphabeticRestriction data = null;
        if (vmodlData != null) {
            data = new PasswordFormat.AlphabeticRestriction(vmodlData.getMinAlphabeticCount(), vmodlData.getMinUppercaseCount(), vmodlData.getMinLowercaseCount());
        }
        return data;
    }

    private static PasswordFormat.AlphabeticRestriction toVmodl(PasswordFormat.AlphabeticRestriction data) {
        PasswordFormat.AlphabeticRestriction vmodlData = null;
        if (data != null) {
            vmodlData = new PasswordFormat.AlphabeticRestriction(data.getMinAlphabeticCount(), data.getMinUppercaseCount(), data.getMinLowercaseCount());
        }
        return vmodlData;
    }

    public static PasswordFormat fromVmodl(com.vmware.vim.binding.sso.admin.PasswordFormat vmodlData) {
        PasswordFormat data = null;
        if (vmodlData != null) {
            data = new PasswordFormat(VmodlTypeConversions.fromVmodl(vmodlData.getLengthRestriction()), VmodlTypeConversions.fromVmodl(vmodlData.getAlphabeticRestriction()), vmodlData.getMinNumericCount(), vmodlData.getMinSpecialCharCount(), vmodlData.getMaxIdenticalAdjacentCharacters());
        }
        return data;
    }

    public static com.vmware.vim.binding.sso.admin.PasswordFormat toVmodl(PasswordFormat data) {
        com.vmware.vim.binding.sso.admin.PasswordFormat vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.PasswordFormat(VmodlTypeConversions.toVmodl(data.getLengthRestriction()), VmodlTypeConversions.toVmodl(data.getAlphabeticRestriction()), data.getMinNumericCount(), data.getMinSpecialCharCount(), data.getMaxIdenticalAdjacentCharacters());
        }
        return vmodlData;
    }

    public static PasswordPolicy fromVmodl(com.vmware.vim.binding.sso.admin.PasswordPolicy vmodlData) {
        PasswordPolicy data = null;
        if (vmodlData != null) {
            data = new PasswordPolicy(vmodlData.getDescription(), vmodlData.getProhibitedPreviousPasswordsCount(), VmodlTypeConversions.fromVmodl(vmodlData.getPasswordFormat()), vmodlData.getPasswordLifetimeDays());
        }
        return data;
    }

    public static com.vmware.vim.binding.sso.admin.PasswordPolicy toVmodl(PasswordPolicy policy) {
        com.vmware.vim.binding.sso.admin.PasswordPolicy vmodlData = policy == null ? null : new com.vmware.vim.binding.sso.admin.PasswordPolicy(policy.getDescription(), policy.getProhibitedPreviousPasswordsCount(), VmodlTypeConversions.toVmodl(policy.getPasswordFormat()), policy.getPasswordLifetimeDays());
        return vmodlData;
    }

    public static LockoutPolicy fromVmodl(com.vmware.vim.binding.sso.admin.LockoutPolicy vmodlData) {
        return vmodlData != null ? new LockoutPolicy(vmodlData.getDescription(), vmodlData.getFailedAttemptIntervalSec(), vmodlData.getMaxFailedAttempts(), vmodlData.getAutoUnlockIntervalSec()) : null;
    }

    public static com.vmware.vim.binding.sso.admin.LockoutPolicy toVmodl(LockoutPolicy data) {
        com.vmware.vim.binding.sso.admin.LockoutPolicy vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.LockoutPolicy(data.getDescription(), data.getMaxFailedAttempts(), data.getFailedAttemptIntervalSec(), data.getAutoUnlockIntervalSec());
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.admin.ExternalDomainDetails toVmodl(ExternalDomainDetails data) {
        com.vmware.vim.binding.sso.admin.ExternalDomainDetails vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.ExternalDomainDetails(data.getFriendlyName(), data.getUserBaseDn(), data.getGroupBaseDn(), data.getPrimaryUrl(), data.getFailoverUrl(), data.getSearchTimeoutSeconds());
        }
        return vmodlData;
    }

    public static SmtpConfig fromVmodl(com.vmware.vim.binding.sso.admin.SmtpConfig vmodlData) {
        SmtpConfig result = null;
        if (vmodlData != null) {
            char[] password = vmodlData.getPassword() != null ? vmodlData.getPassword().toCharArray() : null;
            result = new SmtpConfig(vmodlData.getHost(), vmodlData.getPort(), vmodlData.isAuthenticate(), vmodlData.getUser(), password);
        }
        return result;
    }

    public static PrincipalId fromVmodl(com.vmware.vim.binding.sso.PrincipalId vmodlData) {
        return vmodlData != null ? new PrincipalId(vmodlData.getName(), vmodlData.getDomain()) : null;
    }

    public static PrincipalId[] fromVmodl(com.vmware.vim.binding.sso.PrincipalId[] vmodlData) {
        PrincipalId[] data = null;
        if (vmodlData != null) {
            int size = vmodlData.length;
            data = new PrincipalId[size];
            for (int i = 0; i < size; ++i) {
                data[i] = VmodlTypeConversions.fromVmodl(vmodlData[i]);
            }
        }
        return data;
    }

    public static PersonDetails fromVmodl(com.vmware.vim.binding.sso.admin.PersonDetails vmodlData) {
        PersonDetails data = null;
        if (vmodlData != null) {
            PersonDetails.Builder details = new PersonDetails.Builder();
            details.setDescription(vmodlData.getDescription());
            details.setEmailAddress(vmodlData.getEmailAddress());
            details.setFirstName(vmodlData.getFirstName());
            details.setLastName(vmodlData.getLastName());
            data = details.createPersonDetails();
        }
        return data;
    }

    public static PersonUser fromVmodl(com.vmware.vim.binding.sso.admin.PersonUser data) {
        return data != null ? new PersonUser(VmodlTypeConversions.fromVmodl(data.id), VmodlTypeConversions.fromVmodl(data.alias), VmodlTypeConversions.fromVmodl(data.details), data.isDisabled(), data.isLocked()) : null;
    }

    public static GroupDetails fromVmodl(com.vmware.vim.binding.sso.admin.GroupDetails vmodlData) {
        GroupDetails result = null;
        if (vmodlData != null) {
            result = vmodlData.getDescription() != null ? new GroupDetails(vmodlData.getDescription()) : new GroupDetails();
        }
        return result;
    }

    public static String certificateToVmodl(X509Certificate data) {
        return data != null ? CertificateUtil.encodeCertificate(data) : null;
    }

    public static X509Certificate certificateFromVmodl(String base64Cert) {
        return base64Cert != null ? CertificateUtil.decodeCertificate(base64Cert) : null;
    }

    public static String toVmodl(PrivateKey privateKey) {
        return privateKey != null ? Base64.encodeBase64String((byte[])privateKey.getEncoded()) : null;
    }

    public static Set<Group> fromVmodl(com.vmware.vim.binding.sso.admin.Group[] data) {
        HashSet<Group> result = new HashSet<Group>();
        if (data != null) {
            for (com.vmware.vim.binding.sso.admin.Group group : data) {
                result.add(VmodlTypeConversions.fromVmodl(group));
            }
        }
        return result;
    }

    public static Set<PersonUser> fromVmodl(com.vmware.vim.binding.sso.admin.PersonUser[] data) {
        HashSet<PersonUser> result = new HashSet<PersonUser>();
        if (data != null) {
            for (com.vmware.vim.binding.sso.admin.PersonUser user : data) {
                result.add(VmodlTypeConversions.fromVmodl(user));
            }
        }
        return result;
    }

    public static Group fromVmodl(com.vmware.vim.binding.sso.admin.Group data) {
        return data != null ? new Group(VmodlTypeConversions.fromVmodl(data.getId()), VmodlTypeConversions.fromVmodl(data.getAlias()), VmodlTypeConversions.fromVmodl(data.getDetails())) : null;
    }

    public static PasswordExpirationConfig fromVmodl(com.vmware.vim.binding.sso.admin.PasswordExpirationConfig vmodlData) {
        PasswordExpirationConfig result = null;
        if (vmodlData != null) {
            result = vmodlData.isEmailNotificationEnabled() ? PasswordExpirationConfig.createNotificationEnabledConfig(vmodlData.getEmailFrom(), vmodlData.getEmailSubject(), vmodlData.getNotificationDays()) : PasswordExpirationConfig.createNotificationDisabledConfig();
        }
        return result;
    }

    public static com.vmware.vim.binding.sso.admin.PasswordExpirationConfig toVmodl(PasswordExpirationConfig data) {
        return data != null ? new com.vmware.vim.binding.sso.admin.PasswordExpirationConfig(data.isEmailNotificationEnabled(), data.getEmailFrom(), data.getEmailSubject(), data.getNotificationDays()) : null;
    }

    public static com.vmware.vim.binding.sso.AboutInfo toVmodl(AboutInfo aboutInfo) {
        com.vmware.vim.binding.sso.AboutInfo vmodlData = aboutInfo != null ? new com.vmware.vim.binding.sso.AboutInfo(aboutInfo.getVersion(), aboutInfo.getBuild(), aboutInfo.getApiRevision(), aboutInfo.getClusterId(), aboutInfo.getDeploymentId()) : null;
        return vmodlData;
    }

    public static AboutInfo fromVmodl(com.vmware.vim.binding.sso.AboutInfo vmodlData) {
        AboutInfo aboutInfo = vmodlData != null ? new AboutInfo(vmodlData.getVersion(), vmodlData.getBuild(), vmodlData.getApiRevision(), vmodlData.getClusterId(), vmodlData.getDeploymentId()) : null;
        return aboutInfo;
    }

    public static Binary toVmodl(InputStream is) throws IOException {
        int CHUNK_SIZE = 16384;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        int lastReadBytes = 0;
        while ((lastReadBytes = is.read(buffer)) != -1) {
            os.write(buffer, 0, lastReadBytes);
        }
        return new BinaryImpl(os.toByteArray());
    }

    public static InputStream fromVmodl(Binary binary) {
        return new ByteArrayInputStream(binary.asArray());
    }
}

