/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.CertificateManagement;
import com.vmware.vim.sso.admin.Domains;
import com.vmware.vim.sso.admin.ExternalDomain;
import com.vmware.vim.sso.admin.ExternalDomainDetails;
import com.vmware.vim.sso.admin.RoleManagement;
import com.vmware.vim.sso.admin.exception.DirectoryServiceConnectionException;
import com.vmware.vim.sso.admin.exception.DomainNotFoundException;
import com.vmware.vim.sso.admin.exception.DuplicateDomainNameException;
import com.vmware.vim.sso.admin.exception.LocalOSDomainRegistrationException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.net.URI;
import java.util.List;

public interface DomainManagement {
    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void probeConnectivity(URI var1, ExternalDomain.AuthenticationType var2, AuthenticationCredentails var3) throws DirectoryServiceConnectionException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void addExternalDomain(ExternalDomain.Type var1, String var2, String var3, ExternalDomainDetails var4, ExternalDomain.AuthenticationType var5, AuthenticationCredentails var6) throws DuplicateDomainNameException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void registerLocalOSDomain(String var1) throws DuplicateDomainNameException, NotAuthenticatedException, NoPermissionException, LocalOSDomainRegistrationException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public Domains getDomains() throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Anonymous)
    public String getSystemDomainName();

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public String getLocalOSDomainName() throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public ExternalDomain findExternalDomain(String var1) throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void updateExternalDomainDetails(String var1, ExternalDomainDetails var2) throws DomainNotFoundException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void updateExternalDomainAuthnType(String var1, ExternalDomain.AuthenticationType var2, AuthenticationCredentails var3) throws DomainNotFoundException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void deleteDomain(String var1) throws DomainNotFoundException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Anonymous)
    public CertificateManagement getSslCertificateManagement();

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void setDefaultDomains(List<String> var1) throws DomainNotFoundException, DuplicateDomainNameException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public List<String> getDefaultDomains() throws NotAuthenticatedException, NoPermissionException;

    public static final class AuthenticationCredentails {
        private final String _username;
        private final char[] _password;

        public AuthenticationCredentails(String username, char[] password) {
            ValidateUtil.validateNotEmpty(username, "username");
            ValidateUtil.validateNotNull(password, "password");
            this._username = username;
            this._password = password;
        }

        public String getUsername() {
            return this._username;
        }

        public char[] getPassword() {
            return this._password;
        }
    }
}

