/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.impl.util;

import com.vmware.vim.binding.impl.vmodl.BinaryImpl;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.IdentitySourceManagementService;
import com.vmware.vim.binding.sso.admin.LdapIdentitySource;
import com.vmware.vim.binding.sso.admin.PasswordFormat;
import com.vmware.vim.binding.sso.admin.PrincipalDiscoveryService;
import com.vmware.vim.binding.sso.admin.RoleManagementService;
import com.vmware.vim.binding.vmodl.Binary;
import com.vmware.vim.sso.AboutInfo;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.ActiveDirectoryJoinInfo;
import com.vmware.vim.sso.admin.AttributeConfig;
import com.vmware.vim.sso.admin.Domain;
import com.vmware.vim.sso.admin.ExternalDomainAttributeMapping;
import com.vmware.vim.sso.admin.ExternalDomainDetails;
import com.vmware.vim.sso.admin.ExternalDomainObjectMapping;
import com.vmware.vim.sso.admin.ExternalDomainSchemaDetails;
import com.vmware.vim.sso.admin.GenericIdentitySource;
import com.vmware.vim.sso.admin.Group;
import com.vmware.vim.sso.admin.GroupDetails;
import com.vmware.vim.sso.admin.IdentitySource;
import com.vmware.vim.sso.admin.IdentitySourceManagement;
import com.vmware.vim.sso.admin.IdentitySources;
import com.vmware.vim.sso.admin.LdapIdentitySource;
import com.vmware.vim.sso.admin.LdapIdentitySourceDetails;
import com.vmware.vim.sso.admin.LockoutPolicy;
import com.vmware.vim.sso.admin.PasswordExpirationConfig;
import com.vmware.vim.sso.admin.PasswordFormat;
import com.vmware.vim.sso.admin.PasswordPolicy;
import com.vmware.vim.sso.admin.PersonDetails;
import com.vmware.vim.sso.admin.PersonUser;
import com.vmware.vim.sso.admin.PrincipalDiscovery;
import com.vmware.vim.sso.admin.RoleManagement;
import com.vmware.vim.sso.admin.SmtpConfig;
import com.vmware.vim.sso.admin.SolutionDetails;
import com.vmware.vim.sso.admin.TrustedSTSConfig;
import com.vmware.vim.sso.admin.util.CertificateUtil;
import com.vmware.vim.sso.client.util.codec.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class VmodlTypeConversions {
    static final /* synthetic */ boolean $assertionsDisabled;

    private VmodlTypeConversions() {
    }

    public static com.vmware.vim.binding.sso.PrincipalId toVmodl(PrincipalId data) {
        com.vmware.vim.binding.sso.PrincipalId vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.PrincipalId(data.getName(), data.getDomain());
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.PrincipalId[] toVmodl(PrincipalId[] data) {
        com.vmware.vim.binding.sso.PrincipalId[] vmodlData = null;
        if (data != null) {
            int size = data.length;
            vmodlData = new com.vmware.vim.binding.sso.PrincipalId[size];
            for (int i = 0; i < size; ++i) {
                vmodlData[i] = VmodlTypeConversions.toVmodl(data[i]);
            }
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.admin.GroupDetails toVmodl(GroupDetails data) {
        com.vmware.vim.binding.sso.admin.GroupDetails vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.GroupDetails(data.getDescription());
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.admin.PersonDetails toVmodl(PersonDetails data) {
        com.vmware.vim.binding.sso.admin.PersonDetails vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.PersonDetails(data.getDescription(), data.getEmailAddress(), data.getFirstName(), data.getLastName(), data.getUserPrincipalName());
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.admin.SolutionDetails toVmodl(SolutionDetails data) {
        com.vmware.vim.binding.sso.admin.SolutionDetails vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.SolutionDetails(data.getDescription(), VmodlTypeConversions.certificateToVmodl(data.getCertificate()));
        }
        return vmodlData;
    }

    public static PrincipalDiscoveryService.SearchCriteria toVmodl(PrincipalDiscovery.SearchCriteria data) {
        PrincipalDiscoveryService.SearchCriteria vmodlData = null;
        if (data != null) {
            vmodlData = new PrincipalDiscoveryService.SearchCriteria(data.getSearchString(), data.getDomain());
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.admin.ActiveDirectoryJoinInfo toVmodl(ActiveDirectoryJoinInfo joinInfo) {
        com.vmware.vim.binding.sso.admin.ActiveDirectoryJoinInfo vmodlData = null;
        if (joinInfo != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.ActiveDirectoryJoinInfo(joinInfo.getJoinStatus().toString(), joinInfo.getName(), joinInfo.getAlias());
        }
        return vmodlData;
    }

    public static ActiveDirectoryJoinInfo fromVmodl(com.vmware.vim.binding.sso.admin.ActiveDirectoryJoinInfo vmodlData) {
        ActiveDirectoryJoinInfo data = null;
        if (vmodlData != null) {
            data = new ActiveDirectoryJoinInfo(vmodlData.getName(), vmodlData.getAlias());
        }
        return data;
    }

    public static com.vmware.vim.binding.sso.admin.SmtpConfig toVmodl(SmtpConfig data) {
        com.vmware.vim.binding.sso.admin.SmtpConfig result = null;
        if (data != null) {
            String host = data.getHost();
            int port = data.getPort();
            boolean authenticate = data.isAuthenticate();
            String user = data.getUser();
            String password = data.getPassword() != null ? new String(data.getPassword()) : null;
            result = new com.vmware.vim.binding.sso.admin.SmtpConfig(host, Integer.valueOf(port), Boolean.valueOf(authenticate), user, password);
        }
        return result;
    }

    private static PasswordFormat.LengthRestriction fromVmodl(PasswordFormat.LengthRestriction vmodlData) {
        PasswordFormat.LengthRestriction data = null;
        if (vmodlData != null) {
            data = new PasswordFormat.LengthRestriction(vmodlData.getMinLength(), vmodlData.getMaxLength());
        }
        return data;
    }

    private static PasswordFormat.LengthRestriction toVmodl(PasswordFormat.LengthRestriction data) {
        PasswordFormat.LengthRestriction vmodlData = null;
        if (data != null) {
            vmodlData = new PasswordFormat.LengthRestriction(data.getMinLength(), data.getMaxLength());
        }
        return vmodlData;
    }

    private static PasswordFormat.AlphabeticRestriction fromVmodl(PasswordFormat.AlphabeticRestriction vmodlData) {
        PasswordFormat.AlphabeticRestriction data = null;
        if (vmodlData != null) {
            data = new PasswordFormat.AlphabeticRestriction(vmodlData.getMinAlphabeticCount(), vmodlData.getMinUppercaseCount(), vmodlData.getMinLowercaseCount());
        }
        return data;
    }

    private static PasswordFormat.AlphabeticRestriction toVmodl(PasswordFormat.AlphabeticRestriction data) {
        PasswordFormat.AlphabeticRestriction vmodlData = null;
        if (data != null) {
            vmodlData = new PasswordFormat.AlphabeticRestriction(data.getMinAlphabeticCount(), data.getMinUppercaseCount(), data.getMinLowercaseCount());
        }
        return vmodlData;
    }

    public static PasswordFormat fromVmodl(com.vmware.vim.binding.sso.admin.PasswordFormat vmodlData) {
        PasswordFormat data = null;
        if (vmodlData != null) {
            data = new PasswordFormat(VmodlTypeConversions.fromVmodl(vmodlData.getLengthRestriction()), VmodlTypeConversions.fromVmodl(vmodlData.getAlphabeticRestriction()), vmodlData.getMinNumericCount(), vmodlData.getMinSpecialCharCount(), vmodlData.getMaxIdenticalAdjacentCharacters());
        }
        return data;
    }

    public static com.vmware.vim.binding.sso.admin.PasswordFormat toVmodl(PasswordFormat data) {
        com.vmware.vim.binding.sso.admin.PasswordFormat vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.PasswordFormat(VmodlTypeConversions.toVmodl(data.getLengthRestriction()), VmodlTypeConversions.toVmodl(data.getAlphabeticRestriction()), data.getMinNumericCount(), data.getMinSpecialCharCount(), data.getMaxIdenticalAdjacentCharacters());
        }
        return vmodlData;
    }

    public static PasswordPolicy fromVmodl(com.vmware.vim.binding.sso.admin.PasswordPolicy vmodlData) {
        PasswordPolicy data = null;
        if (vmodlData != null) {
            data = new PasswordPolicy(vmodlData.getDescription(), vmodlData.getProhibitedPreviousPasswordsCount(), VmodlTypeConversions.fromVmodl(vmodlData.getPasswordFormat()), vmodlData.getPasswordLifetimeDays());
        }
        return data;
    }

    public static com.vmware.vim.binding.sso.admin.PasswordPolicy toVmodl(PasswordPolicy policy) {
        com.vmware.vim.binding.sso.admin.PasswordPolicy vmodlData = policy == null ? null : new com.vmware.vim.binding.sso.admin.PasswordPolicy(policy.getDescription(), policy.getProhibitedPreviousPasswordsCount(), VmodlTypeConversions.toVmodl(policy.getPasswordFormat()), policy.getPasswordLifetimeDays());
        return vmodlData;
    }

    public static LockoutPolicy fromVmodl(com.vmware.vim.binding.sso.admin.LockoutPolicy vmodlData) {
        return vmodlData != null ? new LockoutPolicy(vmodlData.getDescription(), vmodlData.getFailedAttemptIntervalSec(), vmodlData.getMaxFailedAttempts(), vmodlData.getAutoUnlockIntervalSec()) : null;
    }

    public static com.vmware.vim.binding.sso.admin.LockoutPolicy toVmodl(LockoutPolicy data) {
        com.vmware.vim.binding.sso.admin.LockoutPolicy vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.LockoutPolicy(data.getDescription(), data.getFailedAttempts(), Integer.valueOf(data.getFailedAttempts()), data.getFailedAttemptIntervalSec(), data.getAutoUnlockIntervalSec());
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.admin.ExternalDomainDetails toVmodl(ExternalDomainDetails data) {
        com.vmware.vim.binding.sso.admin.ExternalDomainDetails vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.ExternalDomainDetails(data.getFriendlyName(), data.getUserBaseDn(), data.getGroupBaseDn(), data.getPrimaryUrl(), data.getFailoverUrl(), data.getSearchTimeoutSeconds(), VmodlTypeConversions.toVmodl(data.getSchemaDetails()), data.getUpnSuffixes() != null ? data.getUpnSuffixes().toArray(new String[0]) : null);
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.admin.ExternalDomainSchemaDetails toVmodl(ExternalDomainSchemaDetails data) {
        com.vmware.vim.binding.sso.admin.ExternalDomainSchemaDetails vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.ExternalDomainSchemaDetails();
            Collection<ExternalDomainObjectMapping> objects = data.getMappedObjects();
            if (objects != null && objects.size() > 0) {
                com.vmware.vim.binding.sso.admin.ExternalDomainObjectMapping[] mappings = new com.vmware.vim.binding.sso.admin.ExternalDomainObjectMapping[objects.size()];
                int i = 0;
                for (ExternalDomainObjectMapping mapping : objects) {
                    mappings[i] = VmodlTypeConversions.toVmodl(mapping);
                    ++i;
                }
                vmodlData.setObjectMappings(mappings);
            }
        }
        return vmodlData;
    }

    private static com.vmware.vim.binding.sso.admin.ExternalDomainObjectMapping toVmodl(ExternalDomainObjectMapping data) {
        com.vmware.vim.binding.sso.admin.ExternalDomainObjectMapping vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.ExternalDomainObjectMapping();
            vmodlData.setObjectId(data.getObjectId());
            vmodlData.setObjectClass(data.getObjectClass());
            Collection<ExternalDomainAttributeMapping> attributes = data.getMappedAttributes();
            if (attributes != null && attributes.size() > 0) {
                com.vmware.vim.binding.sso.admin.ExternalDomainAttributeMapping[] mappings = new com.vmware.vim.binding.sso.admin.ExternalDomainAttributeMapping[attributes.size()];
                int i = 0;
                for (ExternalDomainAttributeMapping mapping : attributes) {
                    mappings[i] = VmodlTypeConversions.toVmodl(mapping);
                    ++i;
                }
                vmodlData.setAttributeMappings(mappings);
            }
        }
        return vmodlData;
    }

    private static com.vmware.vim.binding.sso.admin.ExternalDomainAttributeMapping toVmodl(ExternalDomainAttributeMapping data) {
        com.vmware.vim.binding.sso.admin.ExternalDomainAttributeMapping vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.ExternalDomainAttributeMapping();
            vmodlData.setAttributeId(data.getAttributeId());
            vmodlData.setAttributeName(data.getAttributeName());
        }
        return vmodlData;
    }

    public static com.vmware.vim.binding.sso.admin.TrustedSTSConfig toVmodl(TrustedSTSConfig stsConfig) {
        com.vmware.vim.binding.sso.admin.TrustedSTSConfig result = null;
        if (stsConfig != null) {
            result = new com.vmware.vim.binding.sso.admin.TrustedSTSConfig(stsConfig.getIssuerName(), VmodlTypeConversions.toVmodl(stsConfig.getCertPath()), VmodlTypeConversions.toVmodl(stsConfig.getSubjectFormatMappings()));
        }
        return result;
    }

    private static ConfigurationManagementService.CertificateChain toVmodl(CertPath data) {
        ConfigurationManagementService.CertificateChain vmodlData = null;
        if (data != null) {
            vmodlData = new ConfigurationManagementService.CertificateChain();
            List<? extends Certificate> pathCerts = data.getCertificates();
            String[] certsEncoded = new String[pathCerts.size()];
            for (int i = 0; i < pathCerts.size(); ++i) {
                try {
                    certsEncoded[i] = VmodlTypeConversions.certificateToVmodl((X509Certificate)pathCerts.get(i));
                    continue;
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Only X.509 certificates are supported", e);
                }
            }
            vmodlData.setCertificates(certsEncoded);
        }
        return vmodlData;
    }

    private static ConfigurationManagementService.AttributeConfig[] toVmodl(AttributeConfig[] subjectFormatMappings) {
        if (subjectFormatMappings == null) {
            return null;
        }
        ArrayList<ConfigurationManagementService.AttributeConfig> converted = new ArrayList<ConfigurationManagementService.AttributeConfig>();
        for (AttributeConfig data : subjectFormatMappings) {
            converted.add(new ConfigurationManagementService.AttributeConfig(data.getTokenAttribute(), data.getStoreAttribute()));
        }
        return converted.toArray(new ConfigurationManagementService.AttributeConfig[converted.size()]);
    }

    public static TrustedSTSConfig fromVmodl(com.vmware.vim.binding.sso.admin.TrustedSTSConfig stsConfig) {
        return new TrustedSTSConfig(stsConfig.getIssuer(), VmodlTypeConversions.fromVmodl(stsConfig.getSigningCertChain()), VmodlTypeConversions.fromVmodl(stsConfig.getSubjectFormatMappings()));
    }

    private static AttributeConfig[] fromVmodl(ConfigurationManagementService.AttributeConfig[] subjectFormatMappings) {
        if (subjectFormatMappings == null) {
            return null;
        }
        ArrayList<AttributeConfig> converted = new ArrayList<AttributeConfig>();
        for (ConfigurationManagementService.AttributeConfig vmodlData : subjectFormatMappings) {
            converted.add(new AttributeConfig(vmodlData.getTokenAttribute(), vmodlData.getStoreAttribute()));
        }
        return converted.toArray(new AttributeConfig[converted.size()]);
    }

    private static CertPath fromVmodl(ConfigurationManagementService.CertificateChain vmodlData) {
        CertPath result = null;
        if (vmodlData != null) {
            try {
                ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
                for (String encoded : vmodlData.getCertificates()) {
                    certs.add(VmodlTypeConversions.certificateFromVmodl(encoded));
                }
                result = CertificateFactory.getInstance("X.509").generateCertPath(certs);
            }
            catch (CertificateException e) {
                throw new IllegalArgumentException("Failed to create CertPath from the given certificate list", e);
            }
        }
        return result;
    }

    public static com.vmware.vim.binding.sso.admin.LdapIdentitySourceDetails toVmodl(LdapIdentitySourceDetails data) {
        com.vmware.vim.binding.sso.admin.LdapIdentitySourceDetails vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.LdapIdentitySourceDetails(data.getFriendlyName(), data.getUserBaseDn(), data.getGroupBaseDn(), data.getPrimaryUrl(), data.getFailoverUrl(), data.getSearchTimeoutSeconds());
        }
        return vmodlData;
    }

    public static LdapIdentitySourceDetails fromVmodl(com.vmware.vim.binding.sso.admin.LdapIdentitySourceDetails vmodlData) {
        LdapIdentitySourceDetails details = null;
        if (vmodlData != null) {
            details = new LdapIdentitySourceDetails(vmodlData.getFriendlyName(), vmodlData.getUserBaseDn(), vmodlData.getGroupBaseDn(), vmodlData.getPrimaryUrl(), vmodlData.getFailoverUrl(), vmodlData.getSearchTimeoutSeconds());
        }
        return details;
    }

    public static SmtpConfig fromVmodl(com.vmware.vim.binding.sso.admin.SmtpConfig vmodlData) {
        SmtpConfig result = null;
        if (vmodlData != null) {
            char[] password = vmodlData.getPassword() != null ? vmodlData.getPassword().toCharArray() : null;
            result = new SmtpConfig(vmodlData.getHost(), vmodlData.getPort(), vmodlData.isAuthenticate(), vmodlData.getUser(), password);
        }
        return result;
    }

    public static PrincipalId fromVmodl(com.vmware.vim.binding.sso.PrincipalId vmodlData) {
        return vmodlData != null ? new PrincipalId(vmodlData.getName(), vmodlData.getDomain()) : null;
    }

    public static PrincipalId[] fromVmodl(com.vmware.vim.binding.sso.PrincipalId[] vmodlData) {
        PrincipalId[] data = null;
        if (vmodlData != null) {
            int size = vmodlData.length;
            data = new PrincipalId[size];
            for (int i = 0; i < size; ++i) {
                data[i] = VmodlTypeConversions.fromVmodl(vmodlData[i]);
            }
        }
        return data;
    }

    public static PersonDetails fromVmodl(com.vmware.vim.binding.sso.admin.PersonDetails vmodlData) {
        PersonDetails data = null;
        if (vmodlData != null) {
            PersonDetails.Builder details = new PersonDetails.Builder();
            details.setDescription(vmodlData.getDescription());
            details.setEmailAddress(vmodlData.getEmailAddress());
            details.setFirstName(vmodlData.getFirstName());
            details.setLastName(vmodlData.getLastName());
            details.setUserPrincipalName(vmodlData.getUserPrincipalName());
            data = details.createPersonDetails();
        }
        return data;
    }

    public static PersonUser fromVmodl(com.vmware.vim.binding.sso.admin.PersonUser data) {
        return data != null ? new PersonUser(VmodlTypeConversions.fromVmodl(data.id), VmodlTypeConversions.fromVmodl(data.alias), VmodlTypeConversions.fromVmodl(data.details), data.isDisabled(), data.isLocked()) : null;
    }

    public static GroupDetails fromVmodl(com.vmware.vim.binding.sso.admin.GroupDetails vmodlData) {
        GroupDetails result = null;
        if (vmodlData != null) {
            result = vmodlData.getDescription() != null ? new GroupDetails(vmodlData.getDescription()) : new GroupDetails();
        }
        return result;
    }

    public static String certificateToVmodl(X509Certificate data) {
        return data != null ? CertificateUtil.encodeCertificate(data) : null;
    }

    public static X509Certificate certificateFromVmodl(String base64Cert) {
        return base64Cert != null ? CertificateUtil.decodeCertificate(base64Cert) : null;
    }

    public static String toVmodl(PrivateKey privateKey) {
        return privateKey != null ? Base64.encodeBase64String((byte[])privateKey.getEncoded()) : null;
    }

    public static String toVmodl(RoleManagement.WSTrustRole role) {
        return role.name();
    }

    public static Set<Group> fromVmodl(com.vmware.vim.binding.sso.admin.Group[] data) {
        HashSet<Group> result = new HashSet<Group>();
        if (data != null) {
            for (com.vmware.vim.binding.sso.admin.Group group : data) {
                result.add(VmodlTypeConversions.fromVmodl(group));
            }
        }
        return result;
    }

    public static Set<PersonUser> fromVmodl(com.vmware.vim.binding.sso.admin.PersonUser[] data) {
        HashSet<PersonUser> result = new HashSet<PersonUser>();
        if (data != null) {
            for (com.vmware.vim.binding.sso.admin.PersonUser user : data) {
                result.add(VmodlTypeConversions.fromVmodl(user));
            }
        }
        return result;
    }

    public static Group fromVmodl(com.vmware.vim.binding.sso.admin.Group data) {
        return data != null ? new Group(VmodlTypeConversions.fromVmodl(data.getId()), VmodlTypeConversions.fromVmodl(data.getAlias()), VmodlTypeConversions.fromVmodl(data.getDetails())) : null;
    }

    public static PasswordExpirationConfig fromVmodl(com.vmware.vim.binding.sso.admin.PasswordExpirationConfig vmodlData) {
        PasswordExpirationConfig result = null;
        if (vmodlData != null) {
            result = vmodlData.isEmailNotificationEnabled() ? PasswordExpirationConfig.createNotificationEnabledConfig(vmodlData.getEmailFrom(), vmodlData.getEmailSubject(), vmodlData.getNotificationDays()) : PasswordExpirationConfig.createNotificationDisabledConfig();
        }
        return result;
    }

    public static com.vmware.vim.binding.sso.admin.PasswordExpirationConfig toVmodl(PasswordExpirationConfig data) {
        return data != null ? new com.vmware.vim.binding.sso.admin.PasswordExpirationConfig(data.isEmailNotificationEnabled(), data.getEmailFrom(), data.getEmailSubject(), data.getNotificationDays()) : null;
    }

    public static com.vmware.vim.binding.sso.AboutInfo toVmodl(AboutInfo aboutInfo) {
        com.vmware.vim.binding.sso.AboutInfo vmodlData = aboutInfo != null ? new com.vmware.vim.binding.sso.AboutInfo(aboutInfo.getVersion(), aboutInfo.getBuild(), aboutInfo.getApiRevision(), aboutInfo.getClusterId(), aboutInfo.getDeploymentId()) : null;
        return vmodlData;
    }

    public static AboutInfo fromVmodl(com.vmware.vim.binding.sso.AboutInfo vmodlData) {
        AboutInfo aboutInfo = vmodlData != null ? new AboutInfo(vmodlData.getVersion(), vmodlData.getBuild(), vmodlData.getApiRevision(), vmodlData.getClusterId(), vmodlData.getDeploymentId()) : null;
        return aboutInfo;
    }

    public static Binary toVmodl(InputStream is) throws IOException {
        int CHUNK_SIZE = 16384;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        int lastReadBytes = 0;
        while ((lastReadBytes = is.read(buffer)) != -1) {
            os.write(buffer, 0, lastReadBytes);
        }
        return new BinaryImpl(os.toByteArray());
    }

    public static Document toVmodlSAMLMetadata(String samlConfigDoc) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        ByteArrayInputStream strIn = new ByteArrayInputStream(samlConfigDoc.getBytes());
        return builder.parse(strIn);
    }

    public static InputStream fromVmodl(Binary binary) {
        return new ByteArrayInputStream(binary.asArray());
    }

    public static String domToVmodl(Document document) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.toString();
    }

    public static IdentitySources fromVmodl(com.vmware.vim.binding.sso.admin.IdentitySources data) {
        return new IdentitySources(VmodlTypeConversions.fromVmodl(data.getLdaps()), VmodlTypeConversions.fromVmodl(data.getSystem()), VmodlTypeConversions.fromVmodl(data.getLocalOS()), VmodlTypeConversions.fromVmodl(data.getNativeAD()));
    }

    public static com.vmware.vim.binding.sso.admin.IdentitySources toVmodl(IdentitySources data) {
        com.vmware.vim.binding.sso.admin.IdentitySources vmodl = null;
        if (data != null) {
            vmodl = new com.vmware.vim.binding.sso.admin.IdentitySources(VmodlTypeConversions.toVmodl(data.getAll()), VmodlTypeConversions.toVmodl(data.getSystem()), VmodlTypeConversions.toVmodl(data.getLocalOS()), VmodlTypeConversions.toVmodlLdap(data.getLdaps()), VmodlTypeConversions.toVmodl(data.getNativeAD()));
        }
        return vmodl;
    }

    private static boolean wstRolesMatchToVmodl() {
        return RoleManagement.WSTrustRole.values().length == RoleManagementService.WSTrustRole.values().length && RoleManagement.WSTrustRole.ActAsUser.name().equals(RoleManagementService.WSTrustRole.ActAsUser.name());
    }

    private static GenericIdentitySource fromVmodl(com.vmware.vim.binding.sso.admin.IdentitySource data) {
        return data != null ? new GenericIdentitySource(data.getName(), VmodlTypeConversions.fromVmodl(data.getDomains())) : null;
    }

    private static com.vmware.vim.binding.sso.admin.LdapIdentitySource[] toVmodlLdap(Set<LdapIdentitySource> data) {
        com.vmware.vim.binding.sso.admin.LdapIdentitySource[] vmodlData = null;
        if (data != null) {
            int size = data.size();
            vmodlData = new com.vmware.vim.binding.sso.admin.LdapIdentitySource[size];
            LdapIdentitySource[] dataArr = data.toArray(new LdapIdentitySource[size]);
            for (int i = 0; i < size; ++i) {
                vmodlData[i] = VmodlTypeConversions.toVmodl(dataArr[i]);
            }
        }
        return vmodlData;
    }

    private static com.vmware.vim.binding.sso.admin.LdapIdentitySource toVmodl(LdapIdentitySource data) {
        com.vmware.vim.binding.sso.admin.LdapIdentitySource vmodlData = null;
        if (data != null) {
            vmodlData = new com.vmware.vim.binding.sso.admin.LdapIdentitySource(data.getName(), VmodlTypeConversions.toVmodlDomains(data.getDomains()), data.getType().name(), VmodlTypeConversions.toVmodl(data.getDetails()), VmodlTypeConversions.toVmodl(data.getAuthenticationDetails()));
        }
        return vmodlData;
    }

    private static LdapIdentitySource.AuthenticationDetails toVmodl(LdapIdentitySource.AuthenticationDetails data) {
        return data != null ? new LdapIdentitySource.AuthenticationDetails(data.getAuthenticationType().name(), data.getUsername()) : null;
    }

    private static com.vmware.vim.binding.sso.admin.IdentitySource[] toVmodl(Set<IdentitySource> data) {
        com.vmware.vim.binding.sso.admin.IdentitySource[] vmodlData = null;
        if (data != null) {
            int size = data.size();
            vmodlData = new com.vmware.vim.binding.sso.admin.IdentitySource[size];
            IdentitySource[] dataArr = data.toArray(new IdentitySource[size]);
            for (int i = 0; i < size; ++i) {
                vmodlData[i] = VmodlTypeConversions.toVmodl(dataArr[i]);
            }
        }
        return vmodlData;
    }

    private static com.vmware.vim.binding.sso.admin.IdentitySource toVmodl(IdentitySource data) {
        return data != null ? new com.vmware.vim.binding.sso.admin.IdentitySource(data.getName(), VmodlTypeConversions.toVmodlDomains(data.getDomains())) : null;
    }

    private static com.vmware.vim.binding.sso.admin.Domain[] toVmodlDomains(Set<Domain> data) {
        com.vmware.vim.binding.sso.admin.Domain[] vmodlData = null;
        if (data != null) {
            int size = data.size();
            vmodlData = new com.vmware.vim.binding.sso.admin.Domain[size];
            Domain[] dataArr = data.toArray(new Domain[size]);
            for (int i = 0; i < size; ++i) {
                vmodlData[i] = VmodlTypeConversions.toVmodl(dataArr[i]);
            }
        }
        return vmodlData;
    }

    private static com.vmware.vim.binding.sso.admin.Domain toVmodl(Domain data) {
        return new com.vmware.vim.binding.sso.admin.Domain(data.getName(), data.getAlias());
    }

    private static Set<LdapIdentitySource> fromVmodl(com.vmware.vim.binding.sso.admin.LdapIdentitySource[] data) {
        HashSet<LdapIdentitySource> result = new HashSet<LdapIdentitySource>();
        if (data != null) {
            for (com.vmware.vim.binding.sso.admin.LdapIdentitySource ids : data) {
                result.add(VmodlTypeConversions.fromVmodl(ids));
            }
        }
        return result;
    }

    private static Set<Domain> fromVmodl(com.vmware.vim.binding.sso.admin.Domain[] data) {
        HashSet<Domain> result = new HashSet<Domain>();
        if (data != null) {
            for (com.vmware.vim.binding.sso.admin.Domain domain : data) {
                result.add(VmodlTypeConversions.fromVmodl(domain));
            }
        }
        return result;
    }

    private static Domain fromVmodl(com.vmware.vim.binding.sso.admin.Domain data) {
        Domain result = null;
        if (data != null) {
            result = new Domain(data.name, data.alias);
        }
        return result;
    }

    private static LdapIdentitySource fromVmodl(com.vmware.vim.binding.sso.admin.LdapIdentitySource data) {
        return new LdapIdentitySource(VmodlTypeConversions.fromVmodl(data.domains[0]), LdapIdentitySource.OtherType.valueOf(data.getType()), VmodlTypeConversions.fromVmodl(data.getDetails()), VmodlTypeConversions.fromVmodl(data.getAuthenticationDetails()));
    }

    public static LdapIdentitySource.AuthenticationDetails fromVmodl(LdapIdentitySource.AuthenticationDetails data) {
        return new LdapIdentitySource.AuthenticationDetails(LdapIdentitySource.OtherAuthType.valueOf(data.getAuthenticationType()), data.getUsername());
    }

    public static IdentitySourceManagement.AuthenticationCredentials fromVmodl(IdentitySourceManagementService.AuthenticationCredentials authnCredentials) {
        IdentitySourceManagement.AuthenticationCredentials data = null;
        if (authnCredentials != null) {
            data = new IdentitySourceManagement.AuthenticationCredentials(authnCredentials.getUsername(), authnCredentials.getPassword().toCharArray(), authnCredentials.getUseMachineAccount() == null ? false : authnCredentials.getUseMachineAccount(), authnCredentials.getSpn());
        }
        return data;
    }

    static {
        boolean bl = $assertionsDisabled = !VmodlTypeConversions.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !VmodlTypeConversions.wstRolesMatchToVmodl()) {
            throw new AssertionError((Object)"WSTrustRole-s do not match the ones in vmodl interface!");
        }
    }
}

