/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.AttributeConfig;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public final class TrustedSTSConfig {
    private final String issuerName;
    private final CertPath certPath;
    private final AttributeConfig[] subjectFormatMappings;

    public TrustedSTSConfig(String issuerName, CertPath certPath, AttributeConfig[] subjectFormatMappings) {
        ValidateUtil.validateNotEmpty(issuerName, "issuerName");
        ValidateUtil.validateNotNull(certPath, "certPath");
        for (Certificate certificate : certPath.getCertificates()) {
            if (certificate instanceof X509Certificate) continue;
            throw new IllegalArgumentException("only X509Certificates can be imported");
        }
        this.issuerName = issuerName;
        this.certPath = certPath;
        this.subjectFormatMappings = subjectFormatMappings;
    }

    public TrustedSTSConfig(String issuerName, CertPath certPath) {
        this(issuerName, certPath, null);
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public AttributeConfig[] getSubjectFormatMappings() {
        return this.subjectFormatMappings;
    }
}

