/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.CertificateManagement;
import com.vmware.vim.sso.admin.ExternalDomainSchemaDetails;
import com.vmware.vim.sso.admin.IdentitySources;
import com.vmware.vim.sso.admin.LdapIdentitySource;
import com.vmware.vim.sso.admin.LdapIdentitySourceDetails;
import com.vmware.vim.sso.admin.RoleManagement;
import com.vmware.vim.sso.admin.exception.ADIDPRegistrationServiceException;
import com.vmware.vim.sso.admin.exception.DirectoryServiceConnectionException;
import com.vmware.vim.sso.admin.exception.DomainNotFoundException;
import com.vmware.vim.sso.admin.exception.DuplicateDomainNameException;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.LocalOSDomainRegistrationException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.net.URI;
import java.security.cert.CertPath;
import java.util.Arrays;
import java.util.List;

public interface IdentitySourceManagement {
    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void registerLdap(LdapIdentitySource.KnownType var1, String var2, String var3, LdapIdentitySourceDetails var4, LdapIdentitySource.KnownAuthenticationType var5, AuthenticationCredentials var6) throws DuplicateDomainNameException, NotAuthenticatedException, NoPermissionException, DirectoryServiceConnectionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void registerActiveDirectory(String var1, AuthenticationCredentials var2, ExternalDomainSchemaDetails var3) throws DuplicateDomainNameException, NotAuthenticatedException, NoPermissionException, InvalidPrincipalException, ADIDPRegistrationServiceException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void registerLocalOS(String var1) throws DuplicateDomainNameException, NotAuthenticatedException, NoPermissionException, LocalOSDomainRegistrationException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public IdentitySources get() throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.NoPrivilege
    public String getSystemDomainName();

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void updateLdap(String var1, LdapIdentitySourceDetails var2) throws DomainNotFoundException, DirectoryServiceConnectionException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void updateLdapAuthnType(String var1, LdapIdentitySource.KnownAuthenticationType var2, AuthenticationCredentials var3) throws DomainNotFoundException, NotAuthenticatedException, NoPermissionException, DirectoryServiceConnectionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void delete(String var1) throws DomainNotFoundException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void setDefaultDomains(List<String> var1) throws DomainNotFoundException, DuplicateDomainNameException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public List<String> getDefaultDomains() throws NotAuthenticatedException, NoPermissionException;

    @RoleManagement.NoPrivilege
    public CertificateManagement getSslCertificateManagement();

    @RoleManagement.Privilege(value=RoleManagement.Role.Administrator)
    public void probeConnectivity(URI var1, LdapIdentitySource.KnownAuthenticationType var2, AuthenticationCredentials var3) throws DirectoryServiceConnectionException, NotAuthenticatedException, NoPermissionException;

    @RoleManagement.Privilege(value=RoleManagement.Role.RegularUser)
    public CertPath getSslIdentity(String var1, int var2) throws DirectoryServiceConnectionException, NotAuthenticatedException, NoPermissionException;

    public static final class AuthenticationCredentials {
        private final String _username;
        private final char[] _password;
        private final boolean _useMachineAccount;
        private final String _spn;

        public AuthenticationCredentials(String username, char[] password) {
            this(username, password, false, null);
        }

        public AuthenticationCredentials(String username, char[] password, boolean useMachineAccount, String spn) {
            if (!useMachineAccount) {
                ValidateUtil.validateNotEmpty(username, "username");
                ValidateUtil.validateNotNull(password, "password");
            }
            this._username = username;
            this._password = password;
            this._useMachineAccount = useMachineAccount;
            this._spn = spn;
        }

        public String getUsername() {
            return this._username;
        }

        public char[] getPassword() {
            return Arrays.copyOf(this._password, this._password.length);
        }

        public String getSpn() {
            return this._spn;
        }

        public boolean useMachineAccount() {
            return this._useMachineAccount;
        }
    }
}

