/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.ExternalDomainObjectMapping;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ExternalDomainSchemaDetails {
    private Map<String, ExternalDomainObjectMapping> _mappedObjects = new HashMap<String, ExternalDomainObjectMapping>();

    private ExternalDomainSchemaDetails(HashMap<String, ExternalDomainObjectMapping> schemaMappings) {
        this._mappedObjects.putAll(schemaMappings);
        this._mappedObjects = Collections.unmodifiableMap(this._mappedObjects);
    }

    public Collection<ExternalDomainObjectMapping> getMappedObjects() {
        return this._mappedObjects.values();
    }

    public ExternalDomainObjectMapping getObjectMapping(String objectId) {
        ValidateUtil.validateNotEmpty(objectId, objectId);
        return this._mappedObjects.get(objectId);
    }

    public String toString() {
        StringBuilder objString = new StringBuilder(200);
        objString.append(super.toString());
        objString.append(" MappedObjects={ ");
        for (ExternalDomainObjectMapping mapping : this._mappedObjects.values()) {
            objString.append(mapping);
            objString.append(", ");
        }
        objString.append(" }");
        return objString.toString();
    }

    public static final class Builder {
        private HashMap<String, ExternalDomainObjectMapping> _objectMappings = new HashMap();

        public void addObjectMapping(ExternalDomainObjectMapping objectMapping) {
            ValidateUtil.validateNotNull(objectMapping, "objectMapping");
            this._objectMappings.put(objectMapping.getObjectId(), objectMapping);
        }

        public ExternalDomainSchemaDetails buildSchemaDetails() {
            return new ExternalDomainSchemaDetails(this._objectMappings);
        }
    }
}

