/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.ExternalDomain;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Domains {
    private final Set<ExternalDomain> _externalDomains;
    private final String _systemDomainName;
    private final String _localOSDomainName;
    private final Set<String> _systemDomainUpnSuffixes;

    public Domains(Set<ExternalDomain> externalDomains, String systemDomainName) {
        ValidateUtil.validateNotEmpty(systemDomainName, "systemDomainName");
        this._externalDomains = externalDomains;
        this._systemDomainName = systemDomainName;
        this._localOSDomainName = null;
        this._systemDomainUpnSuffixes = Collections.emptySet();
    }

    public Domains(Set<ExternalDomain> externalDomains, String systemDomainName, Set<String> systemDomainUpnSuffixes) {
        ValidateUtil.validateNotEmpty(systemDomainName, "systemDomainName");
        this._externalDomains = externalDomains;
        this._systemDomainName = systemDomainName;
        this._localOSDomainName = null;
        this._systemDomainUpnSuffixes = new HashSet<String>();
        if (systemDomainUpnSuffixes != null) {
            this._systemDomainUpnSuffixes.addAll(systemDomainUpnSuffixes);
        }
    }

    public Domains(Set<ExternalDomain> externalDomains, String systemDomainName, String localOSDomainName) {
        this(externalDomains, systemDomainName, localOSDomainName, Collections.emptySet());
    }

    public Domains(Set<ExternalDomain> externalDomains, String systemDomainName, String localOSDomainName, Set<String> systemDomainUpnSuffixes) {
        ValidateUtil.validateNotEmpty(systemDomainName, "systemDomainName");
        ValidateUtil.validateNotEmpty(localOSDomainName, "localOSDomainName");
        this._externalDomains = externalDomains;
        this._systemDomainName = systemDomainName;
        this._localOSDomainName = localOSDomainName;
        this._systemDomainUpnSuffixes = new HashSet<String>();
        if (systemDomainUpnSuffixes != null) {
            this._systemDomainUpnSuffixes.addAll(systemDomainUpnSuffixes);
        }
    }

    public Set<ExternalDomain> getExternalDomains() {
        return this._externalDomains;
    }

    public String getSystemDomainName() {
        return this._systemDomainName;
    }

    public String getLocalOSDomainName() {
        return this._localOSDomainName;
    }

    public Set<String> getSystemDomainUpnSuffixes() {
        return Collections.unmodifiableSet(this._systemDomainUpnSuffixes);
    }
}

