/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg.components.impl;

import com.vmware.sso.cfg.components.AbortExecution;
import com.vmware.sso.cfg.components.Files;
import com.vmware.sso.cfg.components.RollbackSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollbackSupportImpl
implements RollbackSupport {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private File rollbackDir = null;
    private RollbackSupport.RollbackDirection direction = null;

    @Override
    public synchronized void prepareRollback(File serverHomeDir, RollbackSupport.RollbackDirection direction) {
        Validate.notNull((Object)serverHomeDir, (String)"serverHomeDir must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)direction), (String)"direction must not be null", (Object[])new Object[0]);
        if (this.rollbackDir != null) {
            throw new AbortExecution("Internal error: RollbackSupport already prepared.");
        }
        this.direction = direction;
        switch (direction) {
            case Backup: {
                this.prepareForBackup(serverHomeDir);
                break;
            }
            case Restore: {
                this.prepareForRestore(serverHomeDir);
                break;
            }
            default: {
                throw new AbortExecution(String.format("Internal error: unkown RollbackDirection: %s (incomplete implementation?)", direction.name()));
            }
        }
    }

    @Override
    public synchronized void rollbackComplete() {
        if (this.rollbackDir == null) {
            throw new AbortExecution("Internal error: RollbackSupport not yet prepared.");
        }
        if (this.direction == RollbackSupport.RollbackDirection.Restore && !this.rollbackDir.delete()) {
            this.log.debug("Cannot rmdir rollback directory after restore (probably not empty?).");
        }
    }

    @Override
    public synchronized void moveToBackup(File source) {
        this.validateState();
        this.log.debug("Backing up (move) file {} to {}", (Object)source, (Object)this.rollbackDir);
        File target = new File(this.rollbackDir, source.getName());
        try {
            Files.move(source, target);
        }
        catch (IOException e) {
            throw this.fileBackupAbort(source, target, e);
        }
    }

    @Override
    public synchronized void copyToBackup(File source) {
        this.validateState();
        this.log.debug("Backing up (copy) file {} to {}", (Object)source, (Object)this.rollbackDir);
        File target = new File(this.rollbackDir, source.getName());
        try {
            Files.copy(source, target);
        }
        catch (IOException e) {
            throw this.fileBackupAbort(source, target, e);
        }
    }

    @Override
    public synchronized void preserveState(String key, Object state) {
        block5: {
            File target;
            block4: {
                this.validateState();
                target = new File(this.rollbackDir, key);
                if (state == null) break block4;
                ObjectOutputStream out = null;
                try {
                    out = new ObjectOutputStream(new FileOutputStream(target));
                    out.writeObject(state);
                    out.close();
                }
                catch (IOException e) {
                    try {
                        String msg = String.format("I/O error backing up state date to %s : %s", target.getAbsolutePath(), e.getMessage());
                        throw new AbortExecution(msg, e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(out);
                break block5;
            }
            target.delete();
        }
    }

    @Override
    public synchronized void restoreFile(File target, int flags) {
        this.validateState();
        File source = new File(this.rollbackDir, target.getName());
        if (source.exists()) {
            try {
                Files.move(source, target);
            }
            catch (IOException e) {
                throw new AbortExecution(String.format("Critical rollback failure: cannot move file %s to %s : %s.", source.getAbsolutePath(), target.getAbsolutePath(), e.getMessage()));
            }
            this.log.debug("File {} successfully restored from {}\\\\{}", new Object[]{target, this.rollbackDir.getName(), source.getName()});
        } else {
            if ((flags & 1) != 0) {
                throw new AbortExecution(String.format("Required backup file %s\\%s did not exist. Backup data possibly corrupt. Aborting the execution.", this.rollbackDir.getName(), source.getName()));
            }
            this.log.debug("No backup copy exists for {}. Assuming file has not been modified.", (Object)target);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized <T> T restoreState(String key, Class<T> stateType, int flags) {
        T t;
        this.validateState();
        File source = new File(this.rollbackDir, key);
        if (!source.exists()) {
            this.log.debug("State file {} does not exist. Not restoring any data from it.", (Object)source);
            return null;
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(source));
            Object stateObj = in.readObject();
            t = stateType.cast(stateObj);
        }
        catch (IOException e) {
            try {
                throw new AbortExecution(String.format("I/O error loading data from file %s: %s", source.getAbsolutePath(), e.getMessage()), e);
                catch (ClassNotFoundException e2) {
                    throw new AbortExecution(String.format("Data file %s is corrupt, contains unexpected data type: %s", source.getAbsolutePath(), e2.getMessage()), e2);
                }
                catch (ClassCastException e3) {
                    throw new AbortExecution(String.format("Data file %s is corrupt, contains unexpected data type: %s", source.getAbsolutePath(), e3.getMessage()), e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        return t;
    }

    private void prepareForBackup(File serverHomeDir) {
        File rollbackDir = this.getRollbackDir(serverHomeDir);
        this.log.info("The existing configuration will be backed up to {}", (Object)rollbackDir);
        if (rollbackDir.exists()) {
            int backupIdx = 1;
            File rollbackDirBackup = new File(rollbackDir.getAbsolutePath() + "." + backupIdx);
            while (rollbackDirBackup.exists()) {
                rollbackDirBackup = new File(rollbackDir.getAbsolutePath() + "." + ++backupIdx);
            }
            try {
                Files.move(rollbackDir, rollbackDirBackup);
            }
            catch (IOException e) {
                throw this.fileBackupAbort(rollbackDir, rollbackDirBackup, e);
            }
            this.log.info("The backup directory `{}' did already exist and was moved to `{}'", (Object)rollbackDir.getName(), (Object)rollbackDirBackup.getName());
        }
        if (!rollbackDir.mkdirs()) {
            throw new AbortExecution(String.format("Cannot create configuration backup directory %s. Check current user's permissions (try running the tool as Administrator).", new Object[0]));
        }
        this.rollbackDir = rollbackDir;
    }

    private void prepareForRestore(File serverHomeDir) {
        File rollbackDir = this.getRollbackDir(serverHomeDir);
        if (!rollbackDir.exists()) {
            throw new AbortExecution(String.format("Backup directory %s does not exist. No rollback will be performed.", rollbackDir.getAbsolutePath()), 1);
        }
        this.rollbackDir = rollbackDir;
    }

    private void validateState() {
        if (this.rollbackDir == null) {
            throw new IllegalStateException("Internal error: RollbackSupport not prepated. Call RollbackSupport.prepareRollback() first.");
        }
    }

    private AbortExecution fileBackupAbort(File source, File target, IOException e) {
        return new AbortExecution(String.format("Error backing up %s to %s : %s.", source.getAbsolutePath(), target.getAbsolutePath(), e.getMessage()));
    }

    private File getRollbackDir(File serverHomeDir) {
        File rollbackDir = new File(serverHomeDir, "security/vmw-ssl-updater.rollback");
        String userRollbackDirStr = System.getenv("ROLLBACK_BACKUP_FOLDER");
        if (userRollbackDirStr != null) {
            File userRollbackDir = new File(userRollbackDirStr);
            if (userRollbackDir.exists() || userRollbackDir.mkdirs()) {
                rollbackDir = new File(userRollbackDir, "sso-ssl-updater.backup");
            } else {
                this.log.warn("The ROLLBACK_BACKUP_FOLDER: {} does not exist and cannot be created. Defaulting to {}.", (Object)userRollbackDir, (Object)rollbackDir);
            }
        }
        return rollbackDir;
    }
}

