/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg.components.impl;

import com.vmware.sso.cfg.components.AbortExecution;
import com.vmware.sso.cfg.components.LookupServiceTools;
import com.vmware.sso.cfg.components.RollbackSupport;
import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.SearchCriteria;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LookupServiceToolsRemoteImpl
implements LookupServiceTools {
    private static final String LSRECORDS_BACKUP_KEY = "lsrecords.dat";
    private static final URI SSO_STS_TYPE = URI.create("urn:sso:sts");
    private static final URI SSO_ADMIN_TYPE = URI.create("urn:sso:admin");
    private static final URI SSO_GC_TYPE = URI.create("urn:sso:groupcheck");
    private static final ServiceEndpoint[] EMPTY_ENDPOINTS_ARRAY = new ServiceEndpoint[0];
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RollbackSupport rollback;
    private final LookupService lookupService;

    public LookupServiceToolsRemoteImpl(RollbackSupport rollback, LookupService lookupService) {
        assert (rollback != null);
        assert (lookupService != null);
        this.rollback = rollback;
        this.lookupService = lookupService;
    }

    @Override
    public void updateSsoRecords(String hostname, X509Certificate trustAnchor, String lbHostname, X509Certificate lbTrustAnchor, EnumSet<LookupServiceTools.SsoRecordType> localServices, EnumSet<LookupServiceTools.SsoRecordType> loadBalancedServices) {
        Map<LookupServiceTools.SsoRecordType, Service> servicesToUpdate = this.findServicesToUpdate(this.lookupService);
        HashMap<String, List<ServiceEndpoint>> originalEndpoints = new HashMap<String, List<ServiceEndpoint>>();
        for (Service s : servicesToUpdate.values()) {
            originalEndpoints.put(s.serviceId, Arrays.asList(s.endpoints));
        }
        this.rollback.preserveState(LSRECORDS_BACKUP_KEY, originalEndpoints);
        for (LookupServiceTools.SsoRecordType recType : LookupServiceTools.SsoRecordType.values()) {
            X509Certificate fixedTrustAnchor;
            String fixedHostname;
            this.log.debug("Updating the Lookup Service record for the {}", (Object)recType.getFriendlyName());
            Service service = servicesToUpdate.get((Object)recType);
            if (loadBalancedServices.contains((Object)recType)) {
                fixedHostname = lbHostname;
                fixedTrustAnchor = lbTrustAnchor;
            } else if (localServices.contains((Object)recType)) {
                fixedHostname = hostname;
                fixedTrustAnchor = trustAnchor;
            } else {
                fixedHostname = null;
                fixedTrustAnchor = null;
            }
            if (fixedHostname == null && fixedTrustAnchor == null) continue;
            Service fixedService = this.fixupService(service, fixedHostname, fixedTrustAnchor);
            this.updateService(this.lookupService, fixedService);
        }
    }

    @Override
    public void rollbackSsoRecords() {
        Map originalEndpoints = this.rollback.restoreState(LSRECORDS_BACKUP_KEY, Map.class, 0);
        if (originalEndpoints != null) {
            for (Map.Entry serviceData : originalEndpoints.entrySet()) {
                Service restored = this.restoreServiceEndpoints(this.lookupService, (String)serviceData.getKey(), (List)serviceData.getValue());
                this.updateService(this.lookupService, restored);
            }
            this.rollback.preserveState(LSRECORDS_BACKUP_KEY, null);
        } else {
            this.log.info("No backup data of LS records found.");
        }
    }

    private Service fixupService(Service svc, String hostname, X509Certificate trustAnchor) {
        assert (svc != null);
        ServiceEndpoint[] fixedEndpoints = this.fixupServiceEndpoints(svc.serviceId, svc.endpoints, hostname, trustAnchor);
        return this.shallowCopyService(svc, fixedEndpoints);
    }

    private ServiceEndpoint[] fixupServiceEndpoints(String serviceId, ServiceEndpoint[] endpoints, String hostname, X509Certificate trustAnchor) {
        String newAnchor;
        URI fixedUrl;
        if (endpoints.length == 0) {
            String msg = String.format("Inconsistent Lookup Service state: service %s has no registered endpoints.", serviceId);
            throw new AbortExecution(msg);
        }
        if (endpoints.length > 1) {
            String msg = String.format("Service %s has multiple endpoints. This deployment layout is uknown; skipping update.", serviceId);
            throw new AbortExecution(msg);
        }
        ServiceEndpoint oldPt = endpoints[0];
        assert (oldPt != null);
        try {
            URI oldUrl = oldPt.url;
            fixedUrl = hostname == null ? oldUrl : new URI(oldUrl.getScheme(), oldUrl.getUserInfo(), hostname, oldUrl.getPort(), oldUrl.getPath(), oldUrl.getQuery(), oldUrl.getFragment());
        }
        catch (URISyntaxException e) {
            throw new AbortExecution("Invalid host name " + hostname, 3, e);
        }
        try {
            newAnchor = trustAnchor == null ? oldPt.sslTrustAnchor : Base64.encodeBase64String(trustAnchor.getEncoded());
        }
        catch (CertificateEncodingException e) {
            assert (trustAnchor != null);
            throw new AbortExecution("Invalid certificate " + trustAnchor.getSubjectX500Principal(), e);
        }
        assert (newAnchor != null && fixedUrl != null);
        ServiceEndpoint fixedPt = new ServiceEndpoint(newAnchor, fixedUrl, oldPt.protocol);
        return new ServiceEndpoint[]{fixedPt};
    }

    private Service restoreServiceEndpoints(LookupService lookupService, String svcId, List<ServiceEndpoint> orignalEndpoints) {
        Service present;
        try {
            present = lookupService.findService(svcId);
        }
        catch (ServiceFault e) {
            throw this.abortExecution(e);
        }
        return this.shallowCopyService(present, orignalEndpoints.toArray(EMPTY_ENDPOINTS_ARRAY));
    }

    private Map<LookupServiceTools.SsoRecordType, Service> findServicesToUpdate(LookupService lookupService) {
        HashMap<LookupServiceTools.SsoRecordType, Service> services = new HashMap<LookupServiceTools.SsoRecordType, Service>();
        try {
            String site = lookupService.getViSite();
            services.put(LookupServiceTools.SsoRecordType.SecurityTokenService, this.findServiceByType(lookupService, site, SSO_STS_TYPE));
            services.put(LookupServiceTools.SsoRecordType.AdminService, this.findServiceByType(lookupService, site, SSO_ADMIN_TYPE));
            services.put(LookupServiceTools.SsoRecordType.GroupCheckService, this.findServiceByType(lookupService, site, SSO_GC_TYPE));
        }
        catch (ServiceFault e) {
            throw this.abortExecution(e);
        }
        return services;
    }

    private Service findServiceByType(LookupService lookupService, String site, URI svcType) throws InvalidArgument, SecurityError, ServiceFault {
        Service[] found = lookupService.find(new SearchCriteria(svcType, site, null));
        if (found.length != 1) {
            throw new AbortExecution(String.format("Expected one service of type %s but %d found. The Lookup Service state is corrupt. Aborting the operation.", svcType, found.length));
        }
        return found[0];
    }

    private void updateService(LookupService lookupService, Service fixedService) {
        assert (lookupService != null);
        assert (fixedService != null);
        try {
            lookupService.updateService(fixedService);
        }
        catch (ServiceFault e) {
            throw this.abortExecution(e);
        }
    }

    private Service shallowCopyService(Service svc, ServiceEndpoint[] newEndpoints) {
        Service svcBld = new Service();
        svcBld.serviceId = svc.serviceId;
        svcBld.version = svc.version;
        svcBld.type = svc.type;
        svcBld.ownerId = svc.ownerId;
        svcBld.viSite = svc.viSite;
        svcBld.serviceName = svc.serviceName;
        svcBld.description = svc.description;
        svcBld.endpoints = newEndpoints;
        svcBld.productId = svc.productId;
        return svcBld;
    }

    private AbortExecution abortExecution(ServiceFault e) {
        return new AbortExecution("A system error occurred communicating to vCenter Single Sign-On service", e);
    }
}

