/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg.components.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DNSResolver {
    private static final Logger log = LoggerFactory.getLogger(DNSResolver.class);

    public static boolean checkDNS(String hostname) {
        return DNSResolver.checkDNS(hostname, false);
    }

    public static boolean checkDNS(String hostname, boolean mx) {
        List<String> records = DNSResolver.resolveDNS(hostname, mx);
        return records != null && records.size() > 0;
    }

    public static List<String> resolveDNS(String hostname, boolean mx) {
        ArrayList<String> result = new ArrayList<String>();
        String queryDesc = mx ? "MX" : "A/CNAME";
        try {
            String[] stringArray;
            log.debug("DNS validation: resolving DNS for {} ({})", (Object)hostname, (Object)queryDesc);
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("com.sun.jndi.dns.timeout.initial", "5000");
            env.put("com.sun.jndi.dns.timeout.retries", "1");
            InitialDirContext ictx = new InitialDirContext(env);
            if (mx) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "MX";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "A";
                stringArray = stringArray3;
                stringArray3[1] = "CNAME";
            }
            String[] ids = stringArray;
            Attributes attrs = ictx.getAttributes(hostname, ids);
            if (mx) {
                Attribute attr = attrs.get("MX");
                if (attr != null && attr.size() > 0) {
                    NamingEnumeration<?> e = attr.getAll();
                    while (e.hasMore()) {
                        String mxs = (String)e.next();
                        String[] f = mxs.split("\\s+");
                        for (int i = 0; i < f.length; ++i) {
                            if (!f[i].endsWith(".")) continue;
                            result.add(f[i].substring(0, f[i].length() - 1));
                        }
                    }
                    return result;
                }
                log.debug("DNS validation: DNS query of '" + hostname + "' failed");
                return null;
            }
            Attribute attr = attrs.get("A");
            if (attr != null && attr.size() > 0) {
                NamingEnumeration<?> e = attr.getAll();
                while (e.hasMore()) {
                    result.add((String)e.next());
                }
                return result;
            }
            attr = attrs.get("CNAME");
            if (attr != null && attr.size() > 0) {
                NamingEnumeration<?> e = attr.getAll();
                while (e.hasMore()) {
                    String h = (String)e.next();
                    if (h.endsWith(".")) {
                        h = h.substring(0, h.lastIndexOf(46));
                    }
                    log.debug("DNS validation: recursing on CNAME record towards host " + h);
                    result.addAll(DNSResolver.resolveDNS(h, false));
                }
                return result;
            }
            log.debug("DNS validation: DNS query of '" + hostname + "' failed");
            return null;
        }
        catch (NamingException ne) {
            log.debug(String.format("DNS validation: DNS %s query failed: %s", queryDesc, ne.getMessage()), (Throwable)ne);
            return null;
        }
    }
}

