/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.cfg;

import com.vmware.sso.cfg.Parameters;
import com.vmware.sso.cfg.SsoNodeType;
import com.vmware.sso.cfg.components.AbortExecution;
import com.vmware.sso.cfg.components.LookupServiceTools;
import com.vmware.sso.cfg.components.RollbackSupport;
import com.vmware.sso.cfg.components.ServerSslConfig;
import com.vmware.sso.cfg.components.ServerSslConfigFactory;
import com.vmware.sso.cfg.components.ServerTools;
import com.vmware.sso.cfg.components.ServiceControl;
import com.vmware.sso.cfg.components.ServiceControlException;
import com.vmware.sso.cfg.logging.LogConst;
import com.vmware.sso.cfg.store.WinRegistry;
import com.vmware.vim.install.exception.InvalidCredentialsException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.openssl.PEMWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigureWindowsSslCommand {
    private static final String MSG_STARTING_SSO = "Starting the vCenter Single Sign-On service.";
    private static final String MSG_STOPPING_SSO = "Stopping the vCenter Single Sign-On service.";
    private static final String MSG_RUNNING_BUT = "The vCenter Single Sign-On service is currently running but it ";
    private static final String MSG_NOT_RUNNING_BUT = "The vCenter Single Sign-On service is not currently running but it ";
    private static final String MSG_MUST_START = "must be started ";
    private static final String MSG_MUST_STOP = "must be stopped ";
    private static final String MSG_UPDATE_SSL = "in order to perform a portion of the SSL certificate update operation.";
    private static final String MSG_UNDO_SSL = "in order to undo a portion of the SSL certificate update operation.";
    private static final String MSG_MUST_RUN_SSO = "The vCenter Single Sign-On service is not currently running but it must be started in order to perform a portion of the SSL certificate update operation.";
    private static final String MSG_MUST_STOP_SSO = "The vCenter Single Sign-On service is currently running but it must be stopped in order to perform a portion of the SSL certificate update operation.";
    private static final String MSG_MUST_RUN_SSO_UNDO = "The vCenter Single Sign-On service is not currently running but it must be started in order to undo a portion of the SSL certificate update operation.";
    private static final String MSG_MUST_STOP_SSO_UNDO = "The vCenter Single Sign-On service is currently running but it must be stopped in order to undo a portion of the SSL certificate update operation.";
    private static final String MSG_REVERT_SSO_RUN = "The vCenter Single Sign-On service is not currently running but it was in the beginning. Starting it.";
    private static final String MSG_REVERT_SSO_STOP = "The vCenter Single Sign-On service is currently running but it was not in the beginning. Stopping it.";
    private static final String SSO_SERVICE = "VMwareSTS";
    private static final String LS_HOST = "127.0.0.1";
    private static final int LS_PORT = 7080;
    private static final String ERROR_UNEXPECTED = "An error ocurred during the certificate replacement procedure:";
    private static final String SSO_STS_DATA_PATH = "VMware/cis/runtime/VMwareSTS/conf";
    private static final String SSO_CERT_FILE = "ssoserver.crt";
    private static final String SSO_PKCS_FILE = "ssoserver.p12";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ServerSslConfigFactory sslConfigFactory;
    private final ServiceControl serviceCtl;
    private final ServerTools serverTools;
    private final RollbackSupport rollback;
    private final File dataDir = this.getSTSDataPath();
    private final File ssoCert = new File(this.dataDir, "ssoserver.crt");
    private final File ssoP12 = new File(this.dataDir, "ssoserver.p12");

    @Inject
    public ConfigureWindowsSslCommand(ServerSslConfigFactory sslConfigFactory, ServiceControl serviceCtl, WinRegistry registry, ServerTools serverTools, RollbackSupport rollback) {
        this.sslConfigFactory = sslConfigFactory;
        this.serviceCtl = serviceCtl;
        this.serverTools = serverTools;
        this.rollback = rollback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Parameters params) {
        if (!this.haveWorkToDo(params)) {
            this.log.info("No parameters provided that require configuration changes. End.");
            return 0;
        }
        ServerSslConfig sslConfig = params.shouldGenerate() ? this.sslConfigFactory.generate("vCenter Single Sign-on", params.getHostname()) : params.getSslConfig();
        this.log.info("Beginning certificate replacement procedure for Single Sign-On.");
        int exitCode = 2;
        boolean ssoWasRunning = this.isSsoRunning();
        try {
            this.rollback.prepareRollback(this.dataDir, RollbackSupport.RollbackDirection.Backup);
            this.checkAdminUserPassword(params, MSG_MUST_RUN_SSO);
            this.updateSsoIfCan(params, sslConfig);
            this.rollback.rollbackComplete();
            exitCode = 0;
        }
        catch (AbortExecution e) {
            this.logError(e);
            exitCode = e.getStatusCode();
        }
        catch (Exception e) {
            this.logError(e, ERROR_UNEXPECTED);
        }
        finally {
            this.revertSsoServiceState(ssoWasRunning);
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rollback(Parameters params) {
        boolean ssoWasRunning = this.isSsoRunning();
        try {
            this.rollback.prepareRollback(this.dataDir, RollbackSupport.RollbackDirection.Restore);
            this.undo(params);
            this.rollback.rollbackComplete();
            this.log.info("Restore completed.");
        }
        finally {
            this.revertSsoServiceState(ssoWasRunning);
        }
        return 0;
    }

    private void updateSsoIfCan(Parameters params, ServerSslConfig sslConfig) throws Exception {
        this.ensureSsoStopped(MSG_MUST_STOP_SSO);
        try {
            this.updateContainerConfiguration(sslConfig);
            this.updateLsIfCan(params, sslConfig);
        }
        catch (Exception e) {
            this.ensureSsoStopped(MSG_MUST_STOP_SSO_UNDO);
            this.undoStsChanges();
            throw e;
        }
    }

    private void updateLsIfCan(Parameters params, ServerSslConfig sslConfig) throws Exception {
        this.log.trace("In updateLsIfCan");
        LookupServiceTools lsTools = this.createLookupServiceTools(params, MSG_MUST_RUN_SSO);
        try {
            this.updateLsConfiguration(lsTools, sslConfig, params);
        }
        catch (Exception e) {
            this.undoLsChanges(lsTools);
            throw e;
        }
    }

    private boolean haveWorkToDo(Parameters params) {
        boolean haveLbWork = params.getNodeType() != SsoNodeType.Single && (params.getLbHostname() != null || params.getLbCertificate() != null);
        boolean haveNodeWork = params.getSslConfig() != null || params.shouldGenerate() || params.getHostname() != null;
        return haveLbWork || haveNodeWork;
    }

    private File getSTSDataPath() {
        return new File(new File(System.getenv("PROGRAMDATA")), SSO_STS_DATA_PATH);
    }

    private boolean writePKCS(ServerSslConfig sslConfig, File filePath, String password) throws AbortExecution {
        boolean bl;
        FileOutputStream fileStream = null;
        try {
            fileStream = new FileOutputStream(filePath);
            KeyStore pkcsStore = KeyStore.getInstance("PKCS12");
            Certificate[] certArray = sslConfig.getChain().toArray(new Certificate[sslConfig.getChain().size()]);
            pkcsStore.load(null, null);
            pkcsStore.setKeyEntry("ssoserver", sslConfig.getKey(), password.toCharArray(), certArray);
            pkcsStore.store(fileStream, password.toCharArray());
            fileStream.flush();
            bl = true;
        }
        catch (Exception ex) {
            try {
                throw new AbortExecution(String.format("Failed to create PKCS12 File", ex.getMessage()), ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fileStream);
        return bl;
    }

    private boolean writeCertificate(ServerSslConfig sslConfig, File filePath) throws AbortExecution {
        boolean i$;
        FileWriter fileWriter = null;
        PEMWriter pemWriter = null;
        try {
            fileWriter = new FileWriter(filePath);
            pemWriter = new PEMWriter((Writer)fileWriter);
            for (X509Certificate cert : sslConfig.getChain()) {
                pemWriter.writeObject((Object)cert);
            }
            fileWriter.flush();
            pemWriter.close();
            i$ = true;
        }
        catch (IOException e) {
            try {
                throw new AbortExecution(String.format("Failed to create Certificate File", e.getMessage()), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fileWriter);
        return i$;
    }

    private void updateContainerConfiguration(ServerSslConfig sslConfig) throws AbortExecution {
        assert (!this.isSsoRunning());
        this.log.info("Updating service container configuration");
        String trustPasswd = "changeme";
        this.log.debug("Updating STS Files");
        this.rollback.moveToBackup(this.ssoCert);
        this.rollback.moveToBackup(this.ssoP12);
        this.log.debug("Writing the sso SSL certificate in " + this.ssoCert);
        this.writeCertificate(sslConfig, this.ssoCert);
        this.log.debug("Writing the sso SSL certificate and private key in " + this.ssoP12);
        this.writePKCS(sslConfig, this.ssoP12, "changeme");
    }

    private void updateLsConfiguration(LookupServiceTools lsTools, ServerSslConfig sslConfig, Parameters params) {
        EnumSet<LookupServiceTools.SsoRecordType> localServices;
        EnumSet<LookupServiceTools.SsoRecordType> loadBalancedServices;
        assert (this.isSsoRunning());
        this.log.info("Updating the SSO endpoints in the Lookup Service.");
        switch (params.getNodeType()) {
            case Single: {
                loadBalancedServices = EnumSet.noneOf(LookupServiceTools.SsoRecordType.class);
                localServices = EnumSet.allOf(LookupServiceTools.SsoRecordType.class);
                this.log.info("This is Single Sign-On single-node install. All Single Sign-On endpoints are served from this node.");
                break;
            }
            case HA_Primary: {
                loadBalancedServices = EnumSet.of(LookupServiceTools.SsoRecordType.SecurityTokenService, LookupServiceTools.SsoRecordType.GroupCheckService);
                localServices = EnumSet.noneOf(LookupServiceTools.SsoRecordType.class);
                if (params.isAdminIsBehindLb()) {
                    loadBalancedServices.add(LookupServiceTools.SsoRecordType.AdminService);
                } else {
                    localServices.add(LookupServiceTools.SsoRecordType.AdminService);
                }
                this.log.info("This is Single Sign-On HA primary node. The following endpoints are served from this node: {} . The following endpoints are behind load-balancer: {}", (Object)(localServices.isEmpty() ? "none" : StringUtils.join(localServices, (String)", ")), (Object)StringUtils.join(loadBalancedServices, (String)", "));
                break;
            }
            case HA_Failover: {
                loadBalancedServices = EnumSet.of(LookupServiceTools.SsoRecordType.SecurityTokenService, LookupServiceTools.SsoRecordType.GroupCheckService);
                if (params.isAdminIsBehindLb()) {
                    loadBalancedServices.add(LookupServiceTools.SsoRecordType.AdminService);
                }
                localServices = EnumSet.noneOf(LookupServiceTools.SsoRecordType.class);
                this.log.info("This is Single Sign-On HA failover node. No endpoints are served directly from here.");
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Internal error: unexpected SsoNodeType %s (incomplete implementation?)", new Object[]{params.getNodeType()}));
            }
        }
        X509Certificate newTrustAnchor = this.obtainCAcert(sslConfig);
        lsTools.updateSsoRecords(params.getHostname(), newTrustAnchor, params.getLbHostname(), params.getLbCertificate(), localServices, loadBalancedServices);
        this.log.info("Lookup Service records updated successfully.");
    }

    private void undo(Parameters params) {
        this.log.info("Undoing all changes.");
        LookupServiceTools lsTools = this.createLookupServiceTools(params, MSG_MUST_RUN_SSO_UNDO);
        this.undoLsChanges(lsTools);
        this.ensureSsoStopped(MSG_MUST_STOP_SSO_UNDO);
        this.undoStsChanges();
    }

    private void undoLsChanges(LookupServiceTools lsTools) {
        assert (this.isSsoRunning());
        lsTools.rollbackSsoRecords();
    }

    private void undoStsChanges() {
        assert (!this.isSsoRunning());
        this.rollback.restoreFile(this.ssoCert, 0);
        this.rollback.restoreFile(this.ssoP12, 0);
    }

    private void checkAdminUserPassword(Parameters params, String msgRunSso) {
        this.log.info("Checking the password of administrator user {}.", (Object)params.getAdminUser());
        this.createLookupServiceTools(params, msgRunSso);
    }

    private LookupServiceTools createLookupServiceTools(Parameters params, String msgRunSso) {
        LookupServiceTools result;
        if (params.getNodeType() == SsoNodeType.HA_Failover) {
            result = this.serverTools.createNoOpLsTools();
        } else {
            this.ensureSsoStarted(msgRunSso);
            try {
                result = this.serverTools.createLsTools(LS_HOST, 7080, params.getAdminUser(), params.getAdminPassword());
            }
            catch (InvalidCredentialsException e) {
                throw new AbortExecution("The provided admin user's password is incorrect.", 3);
            }
        }
        return result;
    }

    private void revertSsoServiceState(boolean ssoWasRunning) {
        try {
            if (ssoWasRunning) {
                this.ensureSsoStarted(MSG_REVERT_SSO_RUN);
            } else {
                this.ensureSsoStopped(MSG_REVERT_SSO_STOP);
            }
        }
        catch (ServiceControlException e) {
            this.log.warn("Service {} cannot be started automatically: {} Try starting it manually.", (Object)SSO_SERVICE, (Object)e.getMessage());
            this.log.debug("", (Throwable)e);
        }
    }

    private void ensureSsoStarted(String logMsg) {
        if (!this.isSsoRunning()) {
            this.log.info(logMsg);
            this.log.info(LogConst.MARK_VERBOSE, MSG_STARTING_SSO);
            this.serviceCtl.start(SSO_SERVICE);
        }
        assert (this.isSsoRunning());
    }

    private void ensureSsoStopped(String logMsg) {
        if (this.isSsoRunning()) {
            this.log.info(logMsg);
            this.log.info(LogConst.MARK_VERBOSE, MSG_STOPPING_SSO);
            this.serviceCtl.stop(SSO_SERVICE);
        }
        assert (!this.isSsoRunning());
    }

    private boolean isSsoRunning() {
        this.log.debug("Checking if vCenter Single Sign-On service is running.");
        return this.serviceCtl.isRunning(SSO_SERVICE);
    }

    private X509Certificate obtainCAcert(ServerSslConfig sslConfig) {
        return sslConfig.getChain().get(sslConfig.getChain().size() - 1);
    }

    private void logError(Exception exc) {
        this.logError(exc, "");
    }

    private void logError(Exception exc, String msgPrefix) {
        String msg = String.format("%s%s", msgPrefix, exc.getMessage());
        this.log.error(msg);
        this.log.debug("", (Throwable)exc);
    }
}

