/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client;

import com.vmware.vim.sso.client.exception.SsoException;
import com.vmware.vim.sso.client.exception.SsoRuntimeException;
import com.vmware.vim.sso.client.impl.ValidateUtil;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BundleMessageSource {
    private final Log _log = LogFactory.getLog(BundleMessageSource.class);
    private final ResourceBundle _messages;

    public BundleMessageSource(Locale locale) {
        String baseName = this.getClass().getPackage().getName() + ".impl.messages.Messages";
        this._messages = ResourceBundle.getBundle(baseName, locale);
    }

    public String get(Key key) {
        ValidateUtil.validateNotNull((Object)key, "key");
        return this._messages.getString(key._bundleKey);
    }

    public String createMessage(SsoException e) {
        return this.createMessage(e.getMessageKey(), e.getMessageDetails(), e.getMessage());
    }

    public String createMessage(SsoRuntimeException e) {
        return this.createMessage(e.getMessageKey(), e.getMessageDetails(), e.getMessage());
    }

    String createMessage(Key messageKey, Object[] details, String fallbackMessage) {
        if (messageKey == null) {
            return fallbackMessage;
        }
        Object[] localizedDetails = new Object[details != null ? details.length : 0];
        for (int i = 0; i < localizedDetails.length; ++i) {
            localizedDetails[i] = details[i] instanceof Key ? this.get((Key)((Object)details[i])) : details[i];
        }
        try {
            return String.format(this.get(messageKey), localizedDetails);
        }
        catch (IllegalFormatException e) {
            String roughMessage = this.get(messageKey) + " " + Arrays.asList(localizedDetails);
            this._log.warn((Object)("Failed to create valid message for localized pattern&params: " + roughMessage));
            return roughMessage;
        }
    }

    public Locale getLocale() {
        return this._messages.getLocale();
    }

    public static enum Key {
        INVALID_CREDENTIALS("invalidCredentials"),
        INVALID_REQUESTED_TIME_RANGE("invalidRequestedTimeRange"),
        RENEW_NEEDED("renewNeeded"),
        UNABLE_TO_RENEW("unableToRenew"),
        POTENITAL_TAMPERING_OF_REQUEST("potenitalTamperingOfRequest"),
        REQUEST_EXPIRED("requestExpired"),
        SIGNATURE_VALIDATION_FAULT("signatureValidationFault"),
        UNEXPECTED_SERVER_ERROR("unexpectedServerError"),
        TIME_SYNCHRONIZATION_ERROR("timeSynchronizationError"),
        UNEXPECTED_RESPONSE_FORMAT("unexpectedResponseFormat"),
        INTERNAL_CLIENT_ERROR("internalClientError"),
        BAD_SERVER_SSL_CERTIFICATE("serverSslCertficateIsNotTrusted"),
        FAILED_TO_CONNECT_TO_SERVER("failedToConnectToServer"),
        ACCOUNT_LOCKED("accountLocked"),
        REQUEST_AFFECTED_BY_TIME_SKEW("requestAffectedByTimeSkew"),
        PARSER_ERROR("serializationError"),
        FAILED_TO_SIGN_REQUEST("failedToSignRequest");

        private final String _bundleKey;

        private Key(String bundleKey) {
            this._bundleKey = bundleKey;
        }
    }
}

