/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client;

import com.vmware.vim.sso.client.impl.ValidateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Advice {
    private final String _source;
    private final List<AdviceAttribute> _attributes;

    public Advice(String source, List<AdviceAttribute> attributes) {
        ValidateUtil.validateNotNull(source, "Advice source");
        ValidateUtil.validateNotEmpty(attributes, "Advice attributes");
        this._source = source;
        this._attributes = Collections.unmodifiableList(attributes);
    }

    public String getSource() {
        return this._source;
    }

    public List<AdviceAttribute> getAttributes() {
        return this._attributes;
    }

    public int hashCode() {
        return this._source.hashCode() + ((Object)this._attributes).hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Advice) {
            Advice advice = (Advice)o;
            return this._source.equals(advice._source) && ((Object)this._attributes).equals(advice._attributes);
        }
        return false;
    }

    public static final class AdviceAttribute {
        private final String _name;
        private final List<String> _value;

        public AdviceAttribute(String name) {
            this(name, new ArrayList<String>());
        }

        public AdviceAttribute(String name, List<String> value) {
            ValidateUtil.validateNotNull(name, "Advice attribute name");
            ValidateUtil.validateNotNull(value, "Attribute values");
            this._name = name;
            this._value = Collections.unmodifiableList(value);
        }

        public String getName() {
            return this._name;
        }

        public List<String> getValue() {
            return this._value;
        }

        public int hashCode() {
            return this._name.hashCode() + ((Object)this._value).hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AdviceAttribute) {
                AdviceAttribute adviceAttribute = (AdviceAttribute)o;
                return this._name.equals(adviceAttribute._name) && ((Object)this._value).equals(adviceAttribute._value);
            }
            return false;
        }
    }
}

