/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl.unmarshaller;

import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.Environment;
import com.vmware.vim.vmomi.core.soap.impl.unmarshaller.StackContext;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

class PrimitiveStackContext
extends StackContext {
    private Object _value;

    public PrimitiveStackContext(VmodlField field, VmodlType type, StackContext parent, Map<QName, String> attrs, Environment env) throws UnmarshallException {
        super(field, type, parent);
        if (env.isQSFormat()) {
            String href;
            if (type.getKind() == VmodlType.Kind.URI) {
                href = attrs.get(HREF);
                if (href == null) {
                    throw new UnmarshallException("Missing xlink:href attribute");
                }
                try {
                    this._value = new URI(href.trim());
                }
                catch (URISyntaxException e) {
                    throw new UnmarshallException(String.format("Failed to parse URI %s", href));
                }
                this.setValueInParent();
            }
            if (type.getKind() == VmodlType.Kind.STRING && field.isLink()) {
                href = attrs.get(HREF);
                if (href == null) {
                    throw new UnmarshallException("Missing xlink:href attribute");
                }
                if (!href.startsWith("#")) {
                    throw new UnmarshallException(String.format("Link URI %s is not in the right format", href));
                }
                int colonIndex = href.indexOf(58);
                if (colonIndex == -1) {
                    throw new UnmarshallException(String.format("Link URI %s is not in the right format", href));
                }
                String key = href.substring(colonIndex + 1);
                try {
                    key = URLDecoder.decode(key, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnmarshallException(String.format("URI %s cannot be decoded", key));
                }
                this._value = key;
                this.setValueInParent();
            }
        }
    }

    @Override
    public void setValue(Object value) throws UnmarshallException {
        this._value = value;
        this.setValueInParent();
    }

    @Override
    public void setChildValue(VmodlField field, Object value) throws UnmarshallException {
        throw new UnmarshallException();
    }

    @Override
    public void close() {
    }

    @Override
    public StackContext getNestedContext(QName name2, Map<QName, String> attrs, NamespaceContext namespaces) throws UnmarshallException {
        throw new UnmarshallException();
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    private void setValueInParent() throws UnmarshallException {
        if (this.getParentContext() != null) {
            this.getParentContext().setChildValue(this.getField(), this._value);
        }
    }
}

