/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client;

import com.vmware.identity.token.impl.SamlTokenImpl;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SamlTokenFactory;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import java.security.cert.X509Certificate;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Element;

public final class DefaultTokenFactory
implements SamlTokenFactory {
    private static final long DEFAULT_TOKEN_CLOCK_TOLERANCE = 0L;
    private final JAXBContext _jaxbContext = DefaultTokenFactory.createJaxbContext();

    @Override
    public SamlToken parseToken(Element tokenRoot, X509Certificate[] trustedRootCertificates, long clockToleranceSec) throws InvalidTokenException {
        SamlTokenImpl samlTokenImpl = new SamlTokenImpl(tokenRoot, this._jaxbContext);
        samlTokenImpl.validate(trustedRootCertificates, clockToleranceSec);
        return samlTokenImpl;
    }

    @Override
    public SamlToken parseToken(String tokenXml, X509Certificate[] trustedRootCertificates, long clockToleranceSec) throws InvalidTokenException {
        SamlTokenImpl samlTokenImpl = new SamlTokenImpl(tokenXml, this._jaxbContext);
        samlTokenImpl.validate(trustedRootCertificates, clockToleranceSec);
        return samlTokenImpl;
    }

    @Override
    public SamlToken parseToken(String tokenXml, X509Certificate ... trustedRootCertificates) throws InvalidTokenException {
        return this.parseToken(tokenXml, trustedRootCertificates, 0L);
    }

    @Override
    public SamlToken parseToken(Element tokenRoot, X509Certificate ... trustedRootCertificates) throws InvalidTokenException {
        return this.parseToken(tokenRoot, trustedRootCertificates, 0L);
    }

    public static SamlToken createToken(String tokenXml, X509Certificate[] trustedRootCertificates, long clockToleranceSec) throws InvalidTokenException {
        SamlTokenImpl samlTokenImpl = new SamlTokenImpl(tokenXml, DefaultTokenFactory.createJaxbContext());
        samlTokenImpl.validate(trustedRootCertificates, clockToleranceSec);
        return samlTokenImpl;
    }

    public static SamlToken createToken(String tokenXml, X509Certificate ... trustedRootCertificates) throws InvalidTokenException {
        return DefaultTokenFactory.createToken(tokenXml, trustedRootCertificates, 0L);
    }

    public static SamlToken createTokenFromDom(Element tokenRoot, X509Certificate[] trustedRootCertificates, long clockToleranceSec) throws InvalidTokenException {
        SamlTokenImpl samlTokenImpl = new SamlTokenImpl(tokenRoot, DefaultTokenFactory.createJaxbContext());
        samlTokenImpl.validate(trustedRootCertificates, clockToleranceSec);
        return samlTokenImpl;
    }

    public static SamlToken createTokenFromDom(Element tokenRoot, X509Certificate ... trustedRootCertificates) throws InvalidTokenException {
        return DefaultTokenFactory.createTokenFromDom(tokenRoot, trustedRootCertificates, 0L);
    }

    private static JAXBContext createJaxbContext() {
        try {
            return JAXBContext.newInstance((String)"oasis.names.tc.saml._2_0.assertion");
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot initialize JAXBContext.", e);
        }
    }
}

