# Set remote language to the desktop
if [ -n "$DISPLAY" ]; then
   displayNum=`echo $DISPLAY | awk -F':' '{print $NF}'`
   #
   # If DISPLAY is begin with 127.0.0.1 and the number
   # is between 100 and 200, it means this is vmware
   # view session. Remove "127.0.0.1" from DISPLAY, so
   # that session can access local resource.
   #
   if [ "$DISPLAY" = "127.0.0.1:$displayNum" ]; then
      if [ $displayNum -ge 100 -a $displayNum -le 200 ]; then
         export DISPLAY=":$displayNum"
      fi
   fi

   desktopInfoFile="/var/vmware/vmw_desktop/vmw_desktopid.$displayNum"
   if [ -f $desktopInfoFile ]; then
      language=`grep -i -m1 "LANG=" $desktopInfoFile`
      if [ "$?" = "0" ]; then
         export $language
      fi
   fi
fi
