#!/bin/sh

###################################################
# Copyright 2020 VMware, Inc.  All rights reserved.
###################################################

display=$DISPLAY
result=false

while getopts d: o
do
   case $o in
   d)
      display=$OPTARG;;
   esac
done

if [ -n "$display" ]; then
   dpyNum=`echo $display | awk -F':' '{print $NF}'`
   if [ $dpyNum -ge 100 -a $dpyNum -le 200 ]; then
      if [ -d "/var/run/systemd/sessions" ]; then
         for file in `find /var/run/systemd/sessions -type f`
         do
            grep "$display" "$file" && grep "STATE=active" "$file" > /dev/null 2>&1
            if [ "$?" = "0" ]; then
               result=true
               break
            fi
         done

         if [ "$result" != "true" ]; then
            echo "`date`: Display $display greeter is invalid"
            if [ "$USER" = "gdm" ]; then
               dbus-send --system --type=signal /org/vmware/viewagent/Greeter \
                  org.vmware.viewagent.Greeter.GreeterFailed string:$dpyNum
            fi
            exit 1
         fi
      fi
   fi
fi

exit 0
