const Gio = imports.gi.Gio;
const Lang = imports.lang;
const Signals = imports.signals;
const GLib = imports.gi.GLib;

const env_display = GLib.getenv('DISPLAY');
const display = env_display.substr(env_display.indexOf(":")+1);

const dbus_path = '/org/vmware/viewagent/Credentials/D' + display;
const dbus_interface = 'org.vmware.viewagent.Credentials.D' + display;

const VmwareCredentialsIface = '<node> \
<interface name="' + dbus_interface + '"> \
<signal name="UserAuthenticated"> \
    <arg type="s" name="token"/> \
</signal> \
</interface> \
</node>';

const VmwareViewGreeterIface = '<node> \
<interface name="org.vmware.viewagent.Greeter"> \
<signal name="GreeterStarted"> \
    <arg type="s" name="token"/> \
</signal> \
</interface> \
</node>';

const VmwareCredentialsInfo = Gio.DBusInterfaceInfo.new_for_xml(VmwareCredentialsIface);

let _vmwareCredentialsManager = null;

function VmwareCredentials() {
    var self = new Gio.DBusProxy({ g_connection: Gio.DBus.system,
                                   g_interface_name: VmwareCredentialsInfo.name,
                                   g_interface_info: VmwareCredentialsInfo,
                                   g_name: dbus_interface,
                                   g_object_path: dbus_path,
                                   g_flags: (Gio.DBusProxyFlags.DO_NOT_LOAD_PROPERTIES) });
    self.init(null);
    return self;
}

const VmwareCredentialsManager = new Lang.Class({
    Name: 'VmwareCredentialsManager',
    _init: function() {
        this._token = null;

        this._credentials = new VmwareCredentials();
        this._credentials.connectSignal('UserAuthenticated',
                                        Lang.bind(this, this._onUserAuthenticated));


        try {
            if (display >= 100) {
                this._dbusImpl = Gio.DBusExportedObject.wrapJSObject(VmwareViewGreeterIface, this);
                this._dbusImpl.export(Gio.DBus.system, '/org/vmware/viewagent/Greeter');
                this._dbusImpl.emit_signal('GreeterStarted', GLib.Variant.new('(s)', [display]));
                log("VMwareSSO : Greeter started with DISPLAY " + display);
            }
        } catch (e) {
            log("VMwareSSO Error: " + e.message);
        }
    },

    _onUserAuthenticated: function(proxy, sender, [token]) {
        log("VMwareSSO: get token: " + token.substr(0, 5) + "-***-" + token.substr(-16, 5));
        var index = token.search("DISPLAY:");
        var token_display = token.substr(index+8);

        if (env_display.search(token_display) != -1) {
           this._token = token.substring(0, index);
           this.emit('vm-authenticated', this._token);
        }
    },

    hasToken: function() {
        return this._token != null;
    },

    getToken: function() {
        return this._token;
    },

    resetToken: function() {
        this._token = null;
    }
});
Signals.addSignalMethods(VmwareCredentialsManager.prototype);

function getVmwareCredentialsManager() {
    if (!_vmwareCredentialsManager)
        _vmwareCredentialsManager = new VmwareCredentialsManager();

    return _vmwareCredentialsManager;
}
