#!/usr/bin/python
#encoding=utf-8

###################################################
# Copyright 2015-2019 VMware, Inc.  All rights reserved.
###################################################

import commands
import dbus
import dbus.service
import getopt
import gobject
import logging
import os
import platform
import subprocess
import sys
import time


from dbus.mainloop.glib import DBusGMainLoop
DBusGMainLoop(set_as_default=True)

SOCKET_DIR = '/var/run/vmware/viewagent'
SOCKET_FILES = ['sso_socket', 'certlogon_socket']

def ssoWrapper(ssotype, path, interface):
    #
    # Define the SSO dbus object
    #
    class SsoDBusObject(dbus.service.Object):
        #
        # Initialization
        #
        def __init__(self):
            bus = dbus.SystemBus()
            dbus.service.Object.__init__(self, bus, path)
            self._name = dbus.service.BusName(interface, bus)

        #
        # Define the dbus message interface and parameter
        #
        @dbus.service.signal(dbus_interface=interface,
                             signature='s')
        def UserAuthenticated(self, token):
            logging.info("Emitting user authenticated SSO signal.")

        #
        # Send dbus message and exit process
        #
        def sendSsoMessage(self, token):
            self.UserAuthenticated(token)
            exit(0)

    #
    # Define the Smartcard SSO dbus object
    #
    class ScSsoDBusObject(dbus.service.Object):
        #
        # Initialization
        #
        def __init__(self):
            bus = dbus.SystemBus()
            dbus.service.Object.__init__(self, bus, path)
            self._name = dbus.service.BusName(interface, bus)

        #
        # Define the dbus message interface and parameter
        #
        @dbus.service.signal(dbus_interface=interface,
                             signature='s')
        def ScUserAuthenticated(self, token):
            logging.info("Emitting user authenticated SCSSO signal.")

        #
        # Send dbus message and exit process
        #
        def sendSsoMessage(self, token):
            self.ScUserAuthenticated(token)
            exit(0)

    return SsoDBusObject() if ssotype == "sso" else ScSsoDBusObject()

def updateDbusPathNeeded():
    osInfo = platform.platform().lower()

    if (osInfo.find("ubuntu-16.04") != -1):
        return False

    return True

if __name__ == "__main__":
    logging.root.level = logging.DEBUG

    try:
        opts, args = getopt.getopt(sys.argv[1:], "t:d:")
    except getopt.GetoptError:
        exit(1)

    display = ""
    ssotype = ""

    for opt, val in opts:
        if opt == "-t":
           ssotype = val
        elif opt == "-d":
           display = val[1:]
        else:
           logging.error("Invalid parameter. Usage: SsoDBusNotify.py -t [sso | scsso] -d <display>")
           exit(1)

    if display == "" or not (ssotype == "sso" or ssotype == "scsso"):
        logging.error("Invalid parameter display " + display + " or ssotype " + ssotype)
        exit(1)

    # Get the SSO token from STDIN
    token = raw_input("Please input the token:")

    # Add the access premit of sso socket path in selinux for gdm
    try:
        proc = subprocess.Popen(['getenforce'], stdout=subprocess.PIPE)
        if proc.communicate()[0].strip() != "Disabled":
             for fsock in SOCKET_FILES:
                path = os.path.join(SOCKET_DIR, fsock)
                if os.path.exists(path):
                    os.system('chcon -R -u system_u -r object_r -t xdm_var_run_t -l s0 ' + path)

    except OSError as e:
        pass
    except:
        print "Error > ",sys.exc_info()[0]

    # Assemble dbus path and interface
    dbus_path = '/org/vmware/viewagent/Credentials'
    dbus_interface = 'org.vmware.viewagent.Credentials'

    if updateDbusPathNeeded():
       dbus_path = dbus_path + '/D' + display
       dbus_interface = dbus_interface + '.D' + display

    ssoMsg = ssoWrapper(ssotype, dbus_path, dbus_interface)

    # Scheduling the dbus notify event in main loop
    gobject.timeout_add(1000, ssoMsg.sendSsoMessage, token)
    loop = gobject.MainLoop()
    loop.run()
