/*
 * ************************************************************************
 *
 * Copyright 2019-2020 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 * ************************************************************************
 */
const Config = imports.misc.config;

const GLib = imports.gi.GLib;
const Main = imports.ui.main;
const Mainloop = imports.mainloop;
const Meta = imports.gi.Meta;
const Tweener = imports.ui.tweener;
const SwitcherPopup = imports.ui.switcherPopup.SwitcherPopup;
const primaryModifier = imports.ui.switcherPopup.primaryModifier;

const Me = imports.misc.extensionUtils.getCurrentExtension();
const ShadowWindowExtension = Me.imports.shadowWindowExtension;

var POPUP_DELAY_TIMEOUT = imports.ui.switcherPopup.POPUP_DELAY_TIMEOUT;
var POPUP_FADE_OUT_TIME = imports.ui.switcherPopup.POPUP_FADE_OUT_TIME;

var SHADOW_BORDER_ADJUST = 1;

let shadowWindow = {};

let old_SwitcherPopup_show = {};

let new_SwitcherPopup_show_3_28 = function(backward, binding, mask) {
    if (this._items.length == 0)
        return false;

    if (!Main.pushModal(this.actor)) {
        if (!Main.pushModal(this.actor, { options: Meta.ModalOptions.POINTER_ALREADY_GRABBED }))
            return false;
    }
    this._haveModal = true;
    this._modifierMask = primaryModifier(mask);

    this.actor.connect('key-press-event', this._keyPressEvent.bind(this));
    this.actor.connect('key-release-event', this._keyReleaseEvent.bind(this));

    this.actor.connect('button-press-event', this._clickedOutside.bind(this));
    this.actor.connect('scroll-event', this._scrollEvent.bind(this));

    // Change the corner of the IMS popup to right-angle.
    this._switcherList.actor.add_style_class_name('right-angle-dialog');

    this.actor.add_actor(this._switcherList.actor);
    this._switcherList.connect('item-activated', this._itemActivated.bind(this));
    this._switcherList.connect('item-entered', this._itemEntered.bind(this));
    this._switcherList.connect('item-removed', this._itemRemoved.bind(this));

    this.actor.opacity = 0;
    this.actor.show();
    this.actor.get_allocation_box();

    this._initialSelection(backward, binding);

    if (this._modifierMask) {
        let [x, y, mods] = global.get_pointer();
        if (!(mods & this._modifierMask)) {
            this._finish(global.get_current_time());
            return false;
        }
    } else {
        this._resetNoModsTimeout();
    }

    this._initialDelayTimeoutId = Mainloop.timeout_add(POPUP_DELAY_TIMEOUT,
                                                       () => {
                                                   Main.osdWindowManager.hideAll();
                                                   this.actor.opacity = 255;
                                                   this._initialDelayTimeoutId = 0;
                                                   return GLib.SOURCE_REMOVE;
                                                       });
    GLib.Source.set_name_by_id(this._initialDelayTimeoutId,
                               '[gnome-shell] Main.osdWindow.cancel');

    show_shadowwindow(this._switcherList.actor);

    return true;
};

let new_SwitcherPopup_show_3_32 = function(backward, binding, mask) {
    if (this._items.length == 0)
        return false;

    if (!Main.pushModal(this)) {
        // Probably someone else has a pointer grab, try again with keyboard only
        if (!Main.pushModal(this, { options: Meta.ModalOptions.POINTER_ALREADY_GRABBED }))
            return false;
    }
    this._haveModal = true;
    this._modifierMask = primaryModifier(mask);

    this.connect('key-press-event', this._keyPressEvent.bind(this));
    this.connect('key-release-event', this._keyReleaseEvent.bind(this));

    this.connect('button-press-event', this._clickedOutside.bind(this));
    this.connect('scroll-event', this._scrollEvent.bind(this));

    // Change the corner of the IMS popup to right-angle.
    this._switcherList.add_style_class_name('right-angle-dialog');

    this.add_actor(this._switcherList);

    this._switcherList.connect('item-activated', this._itemActivated.bind(this));
    this._switcherList.connect('item-entered', this._itemEntered.bind(this));
    this._switcherList.connect('item-removed', this._itemRemoved.bind(this));

    this.opacity = 0;
    this.visible = true;
    this.get_allocation_box();

    this._initialSelection(backward, binding);

    if (this._modifierMask) {
        let [x, y, mods] = global.get_pointer();
        if (!(mods & this._modifierMask)) {
            this._finish(global.get_current_time());
            return false;
        }
    } else {
        this._resetNoModsTimeout();
    }

    this._initialDelayTimeoutId = Mainloop.timeout_add(POPUP_DELAY_TIMEOUT,
                                                       () => {
                                                           Main.osdWindowManager.hideAll();
                                                           this.opacity = 255;
                                                           this._initialDelayTimeoutId = 0;
                                                           return GLib.SOURCE_REMOVE;
                                                       });
    GLib.Source.set_name_by_id(this._initialDelayTimeoutId,
                               '[gnome-shell] Main.osdWindow.cancel');

    show_shadowwindow(this._switcherList);

    return true;
};

let old_SwitcherPopup_destroy = {};

let new_SwitcherPopup_destroy = function() {
    shadowWindow.hide();
    this._switcherList.actor.remove_style_class_name('right-angle-dialog');

    this._popModal();
    if (this.actor.visible) {
        Tweener.addTween(this.actor,
                         { opacity: 0,
                           time: POPUP_FADE_OUT_TIME,
                           transition: 'easeOutQuad',
                           onComplete: () => {
                               this.actor.destroy();
                           }
                         });
    } else
        this.actor.destroy();
};

let old_SwitcherPopup_fadeAndDestroy = {};

let new_SwitcherPopup_fadeAndDestroy = function() {
    shadowWindow.hide();
    this._switcherList.remove_style_class_name('right-angle-dialog');

    this._popModal();
    if (this.visible) {
        Tweener.addTween(this,
                         { opacity: 0,
                           time: POPUP_FADE_OUT_TIME,
                           transition: 'easeOutQuad',
                           onComplete: () => {
                               this.destroy();
                           }
                         });
    } else
        this.destroy();
};

function show_shadowwindow(actor) {
    let [shadowX, shadowY] = actor.get_transformed_position();
    shadowX = Math.floor(shadowX + SHADOW_BORDER_ADJUST);
    shadowY = Math.floor(shadowY + SHADOW_BORDER_ADJUST);

    let [shadowWidth, shadowHeight] = actor.get_transformed_size();
    shadowWidth = Math.floor(shadowWidth - 2 * SHADOW_BORDER_ADJUST);
    shadowHeight = Math.floor(shadowHeight - 2 * SHADOW_BORDER_ADJUST);

    shadowWindow.draw(shadowX, shadowY, shadowWidth, shadowHeight,
                      ShadowWindowExtension.winType.POPUP,
                      ShadowWindowExtension.winStyle.TRANSPARENT);
}

function init() {
    shadowWindow = new ShadowWindowExtension.ShadowWindow();

    old_SwitcherPopup_show = SwitcherPopup.prototype.show;
    if (Config.PACKAGE_VERSION.startsWith("3.28")) {
        old_SwitcherPopup_destroy = SwitcherPopup.prototype.destroy;
    } else if (Config.PACKAGE_VERSION.startsWith("3.32")) {
        old_SwitcherPopup_fadeAndDestroy = SwitcherPopup.prototype.fadeAndDestroy;
    } else {
        global.log('Not Support ' + Config.PACKAGE_VERSION);
    }
}

function enable() {
    if (Config.PACKAGE_VERSION.startsWith("3.28")) {
        SwitcherPopup.prototype.show = new_SwitcherPopup_show_3_28;
        SwitcherPopup.prototype.destroy = new_SwitcherPopup_destroy;
    } else if (Config.PACKAGE_VERSION.startsWith("3.32")) {
        SwitcherPopup.prototype.show = new_SwitcherPopup_show_3_32;
        SwitcherPopup.prototype.fadeAndDestroy = new_SwitcherPopup_fadeAndDestroy;
    } else {
        global.log('Not Support ' + Config.PACKAGE_VERSION);
    }
}

function disable() {
    SwitcherPopup.prototype.show = old_SwitcherPopup_show;
    if (Config.PACKAGE_VERSION.startsWith("3.28")) {
        SwitcherPopup.prototype.destroy = old_SwitcherPopup_destroy;
    } else if (Config.PACKAGE_VERSION.startsWith("3.32")) {
        SwitcherPopup.prototype.fadeAndDestroy = old_SwitcherPopup_fadeAndDestroy;
    }
}
