/*
 * ************************************************************************
 *
 * Copyright 2019-2020 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 * ************************************************************************
 */

const Lang = imports.lang;
const GnomeSession = imports.misc.gnomeSession;
const ScreenShield = imports.ui.screenShield.ScreenShield;

let old_ScreenShield_onStatusChanged = {};

let new_ScreenShield_onStatusChanged = function(status) {
    if (status != GnomeSession.PresenceStatus.IDLE)
        return;

     this._maybeCancelDialog();
};


function init() {
    old_ScreenShield_onStatusChanged = ScreenShield.prototype._onStatusChanged;
}

function enable() {
    ScreenShield.prototype._onStatusChanged = new_ScreenShield_onStatusChanged;
}

function disable() {
    ScreenShield.prototype._onStatusChanged = old_ScreenShield_onStatusChanged;
}
