/*
 * ************************************************************************
 *
 * Copyright 2019-2020 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 * ************************************************************************
 */
const Config = imports.misc.config;

const BoxPointer = imports.ui.boxpointer;
const Main = imports.ui.main;
const IBusCandidatePopup = imports.ui.ibusCandidatePopup;
const CandidatePopup = IBusCandidatePopup.CandidatePopup;

const GLib = imports.gi.GLib;
const Mainloop = imports.mainloop;

const Me = imports.misc.extensionUtils.getCurrentExtension();
const ShadowWindowExtension = Me.imports.shadowWindowExtension;

var SHADOW_BORDER_ADJUST = 1;
var POPUP_DELAY_TIMEOUT = 75; // milliseconds

let shadowWindow = {};

function on_complete(actor) {
    actor.add_style_class_name('right-angle-dialog');
    Mainloop.timeout_add(POPUP_DELAY_TIMEOUT,
                         () => {
                             show_shadowwindow(actor);
                             return GLib.SOURCE_REMOVE;
                         });
}

let old_updateVisibility = {};

let new_updateVisibility_3_28 = function() {
    let isVisible = (!Main.keyboard.visible &&
                     (this._preeditText.visible ||
                      this._auxText.visible ||
                      this._candidateArea.actor.visible));

    if (isVisible) {
        this._boxPointer.setPosition(Main.layoutManager.dummyCursor, 0);
        this._boxPointer.show(BoxPointer.PopupAnimation.NONE, () => {
                this._boxPointer.actor.add_style_class_name('right-angle-dialog');
                show_shadowwindow(this._boxPointer.actor);
            });
        this._boxPointer.actor.raise_top();
    } else {
        this._boxPointer.actor.remove_style_class_name('right-angle-dialog');
        this._boxPointer.hide(BoxPointer.PopupAnimation.NONE);
        shadowWindow.hide();
    }
};

let new_updateVisibility_3_32 = function() {
    let isVisible = (!Main.keyboard.visible &&
                     (this._preeditText.visible ||
                      this._auxText.visible ||
                      this._candidateArea.actor.visible));

    if (isVisible) {
        this._boxPointer.setPosition(Main.layoutManager.dummyCursor, 0);
        this._boxPointer.open(BoxPointer.PopupAnimation.NONE, () => {
                              on_complete(this._boxPointer);
                              });
        this._boxPointer.actor.raise_top();
    } else {
        this._boxPointer.remove_style_class_name('right-angle-dialog');
        this._boxPointer.close(BoxPointer.PopupAnimation.NONE);
        shadowWindow.hide();
    }
};

function show_shadowwindow(actor) {
    let themeNode = actor.get_theme_node();
    let rise = themeNode.get_length('-arrow-rise');
    if (rise < 0) {
        global.log('Can\'t find -arrow-rise');
        rise = 0;
    }

    let [shadowX, shadowY] = actor.get_transformed_position();
    shadowX = Math.floor(shadowX + SHADOW_BORDER_ADJUST);
    shadowY = Math.floor(shadowY + SHADOW_BORDER_ADJUST);
    shadowY += rise;

    let [shadowWidth, shadowHeight] = actor.get_transformed_size();
    shadowWidth = Math.floor(shadowWidth - SHADOW_BORDER_ADJUST);
    shadowHeight = Math.floor(shadowHeight - SHADOW_BORDER_ADJUST);
    shadowHeight -= rise;

    shadowWindow.draw(shadowX, shadowY, shadowWidth, shadowHeight,
                      ShadowWindowExtension.winType.POPUP,
                      ShadowWindowExtension.winStyle.TRANSPARENT);
}

function init() {
    shadowWindow = new ShadowWindowExtension.ShadowWindow();

    old_updateVisibility = CandidatePopup.prototype._updateVisibility;
}

function enable() {
    if (Config.PACKAGE_VERSION.startsWith("3.28")) {
        CandidatePopup.prototype._updateVisibility
               = new_updateVisibility_3_28;
    } else if (Config.PACKAGE_VERSION.startsWith("3.32")) {
        CandidatePopup.prototype._updateVisibility
               = new_updateVisibility_3_32;
    } else {
        global.log('Not Support ' + Config.PACKAGE_VERSION);
    }
}

function disable() {
    CandidatePopup.prototype._updateVisibility = old_updateVisibility;
}
