/*
 * ************************************************************************
 *
 * Copyright 2019-2020 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 * ************************************************************************
 */

const Clutter = imports.gi.Clutter;
const GDesktopEnums = imports.gi.GDesktopEnums;
const Main = imports.ui.main;
const Background = imports.ui.background;

const COLOR_SHADING_TYPE_KEY = 'color-shading-type';

var BACKGROUND_COLOR = Clutter.Color.from_pixel(0x2e3436ff);

let old_Background_loadPattern = {};

let new_Background_loadPattern = function() {
    let color = BACKGROUND_COLOR;
    let secondColor = BACKGROUND_COLOR;
    let shadingType = this._settings.get_enum(COLOR_SHADING_TYPE_KEY);

    if (shadingType == GDesktopEnums.BackgroundShading.SOLID) {
        this.background.set_color(color);
    }
    else {
        this.background.set_gradient(shadingType, color, secondColor);
    }
};

let old_Background_loadFile = {};

let new_Background_loadFile = function(file) {
    this._loadImage(file);
};

let old_Background_load = {};
let new_Background_load = function() {
    this._cache = Background.getBackgroundCache();
    this._loadPattern();
    this._setLoaded();
};

function init() {
    old_Background_loadPattern = Background.Background.prototype._loadPattern;
    old_Background_loadFile = Background.Background.prototype._loadFile;
    old_Background_load = Background.Background.prototype._load;
}

function enable() {
    let index = Main.layoutManager.primaryIndex;
    let bgSource = Main.layoutManager._bgManagers[index]._backgroundSource;

    Background.Background.prototype._loadPattern = new_Background_loadPattern;
    Background.Background.prototype._loadFile = new_Background_loadFile;
    Background.Background.prototype._load = new_Background_load;
    for (let monitorIndex in bgSource._backgrounds) {
        let background = bgSource._backgrounds[monitorIndex];
        background.emit('changed');
    }
}

function disable() {
    let index = Main.layoutManager.primaryIndex;
    let bgSource = Main.layoutManager._bgManagers[index]._backgroundSource;

    Background.Background.prototype._loadPattern = old_Background_loadPattern;
    Background.Background.prototype._loadFile = old_Background_loadFile;
    Background.Background.prototype._load = old_Background_load;
    for (let monitorIndex in bgSource._backgrounds) {
        let background = bgSource._backgrounds[monitorIndex];
        background.emit('changed');
    }
}
