#!/bin/sh

########################################################
# Copyright 2019 VMware, Inc.  All rights reserved.
########################################################

#
# Main
#

action=""
desktoptype=""
distribution=""

while getopts a:d:t: o
do
   case $o in
   a)
      action="$OPTARG";;
   d)
      distribution="$OPTARG";;
   t)
      desktoptype="$OPTARG";;
   esac
done

if [ "$action" = "lock" ]; then
   if [ "$distribution" = "rhel" ] || [ "$distribution" = "centos" ]; then
      xdg-screensaver lock
   else
      loginctl lock-session
   fi
elif [ "$action" = "unlock" ]; then
   if [ "$distribution" = "rhel" ] || [ "$distribution" = "centos" ]; then
      if [ "$desktoptype" = "gnome" ]; then
         dbus-send --session --dest=org.gnome.ScreenSaver --type=method_call \
                   /org/gnome/ScreenSaver org.gnome.ScreenSaver.SetActive boolean:false
      elif [ "$desktoptype" = "kde" ]; then
         dbus-send --session --dest=org.freedesktop.ScreenSaver --type=method_call \
                  /ScreenSaver org.freedesktop.ScreenSaver.SetActive boolean:false
      fi
   else
      loginctl unlock-session
   fi
elif [ "$action" = "logout" ]; then
   if [ "$desktoptype" = "gnome" ]; then
      which gnome-session-quit && gnome-session-quit --logout --force || \
                                  gnome-session-save --force-logout
   elif [ "$desktoptype" = "mate" ]; then
      which mate-session-save && mate-session-save --force-logout
   elif [ "$desktoptype" = "kde" ]; then
      which qdbus && qdbus org.kde.ksmserver /KSMServer \
                     org.kde.KSMServerInterface.logout 0 0 2
   fi
fi
