#!/bin/sh

### BEGIN INIT INFO
# Provides: vmwareagent
# Required-Start: $network
# Default-Start: 2 3 4 5
# Default-Stop: 0 1 6
# Short-Description: exec shutdown task
### END INIT INFO



ngvcAgentPrefix="`date` - [NGVC-Agent-ShutDown-Script]"
logPath=/var/log/vmware/viewagent-ngvc.log
customizationScriptFolder="/var/userScript"
touch $logPath

runPreShutDownScript() {
   # run pre-shutdown script
   preShutdown=`vmware-rpctool "info-get guestinfo.scripts.PreShutdown"`
   if [ -n "$preShutdown" ]; then
      echo "${ngvcAgentPrefix}: preShutdown: $preShutdown.." >> $logPath
      preShutdownScriptPath=`echo $preShutdown | awk '{print $1}' | sed 's/\"//g'`

      # script folder should be under /etc/vmware which has root:root privilege
      scriptfolder=$(dirname "${preShutdownScriptPath}")
      if [ "$customizationScriptFolder" = "$scriptfolder" ]; then
         if [ -f "$preShutdownScriptPath" ]; then
             scriptWithPara=`echo $preShutdown | sed 's/\"//g'`
             owner=`stat -c "%U" "$preShutdownScriptPath"`
             permission=`stat -c "%a" "$preShutdownScriptPath"`
             if [ "$owner" = "root" ] && [ "$permission" = "700" ]; then
                echo "${ngvcAgentPrefix}: Begining Pre shut down script command: $scriptWithPara" >> $logPath
                $scriptWithPara
                echo "${ngvcAgentPrefix}: Ending pre shut down script, return value is: $?" >> $logPath
             else
                echo "${ngvcAgentPrefix}: pre shut down script owner is not root or the permission is not 700" >> $logPath
             fi
         else
             echo "${ngvcAgentPrefix}: pre shut down script does not exist.." >> $logPath
         fi
      fi
   else
      echo "${ngvcAgentPrefix}: preShutdown does not config.." >> $logPath
   fi
}


start() {
   echo "${ngvcAgentPrefix}: starting pre-shutdown service.." >> $logPath
}

stop() {
   echo "${ngvcAgentPrefix}: Running Pre shut down script." >> $logPath

   while [ -n "`ps -ef | grep -i "standalone" | grep -v "grep" | awk '{print $2}'`" ]
   do
       sleep 1
   done

   vmForked=`grep VMFORKED /etc/vmware/viewagent-config.txt | cut -f2 -d"="`
   if [ "$vmForked" = "1" ]; then
      runPreShutDownScript
   fi

   # cleanup == 1 then release dhcp
   cleanup=`vmware-rpctool "info-get guestinfo.shutdown.cleanup"`
   if [ "$cleanup" = "1" ]; then
      # Relase the dynamic ip address
      dhclient -v -r >> $logPath 2>&1
   else
      echo "${ngvcAgentPrefix}: cleanup is not 1, skip cleanning up." >> $logPath
   fi

   # delete all user environment info files
   rm -rf /var/vmware/view.*

   echo "${ngvcAgentPrefix}: Pre shut down script finish." >> $logPath
}

case "$1" in
    start)
        $1
        ;;
    stop)
        $1
        ;;
    *)
        echo "Usage: $0 {start|stop}" >> $logPath
        exit 2
esac
