#!/bin/bash

###################################################
# Copyright 2018-2019 VMware, Inc.  All rights reserved.
###################################################

xdmcp_security() {
    #
    # TCP wrapper on agent install/uninstall
    #

    # Only high version GMD supports TCP wrapper
    local gdm_bin=$(which gdm || which gdm3)

    if [ -n "$gdm_bin" ] && ldd $gdm_bin | grep libwrap >/dev/null 2>&1
    then
        local tcp_wrap_allow=/etc/hosts.allow
        local allow_rule='gdm: 127.0.0.1, LOCAL'
        local tcp_wrap_deny=/etc/hosts.deny
        local deny_rule='gdm: ALL'
        if [ "$1" = "install" ]
        then
            echo $allow_rule >> $tcp_wrap_allow
            echo $deny_rule >> $tcp_wrap_deny
        elif [ "$1" = "uninstall" ]
        then
            sed -i -e "/$allow_rule/d" $tcp_wrap_allow
            sed -i -e "/$deny_rule/d" $tcp_wrap_deny
        fi
    fi

    #
    # Firewall on service start/stop
    #
    if [ "$1" = "start" -o "$1" = "stop" ]
    then
        local xdmcp_port=177    # The default one
        local x_port=6100       # 6000 + diplay number (100 by now)
        local xdmcp_port_rule=(! -i lo -p udp -m udp --dport $xdmcp_port -j REJECT)
        local x_port_rule=(! -i lo -p tcp -m tcp --dport $x_port -j REJECT)
        local is_start=(test "$1" = "start")
        local iptables_action=$("${is_start[@]}" && printf %s "-I" || printf %s "-D")
        local firewalld_action=$("${is_start[@]}" && printf %s "--add-rule" || printf %s "--remove-rule")
        local ip_version
        if firewall-cmd --list-all # Firstly try firewalld
        then
            for ip_version in ipv4 ipv6
            do
                firewall-cmd --direct $firewalld_action $ip_version filter INPUT 0 "${x_port_rule[@]}"
                firewall-cmd --direct $firewalld_action $ip_version filter INPUT 0 "${xdmcp_port_rule[@]}"
                firewall-cmd --permanent --direct $firewalld_action $ip_version filter INPUT 0 "${x_port_rule[@]}"
                firewall-cmd --permanent --direct $firewalld_action $ip_version filter INPUT 0 "${xdmcp_port_rule[@]}"
            done
        elif iptables -S        # Secondly try iptables
        then
            iptables $iptables_action INPUT "${x_port_rule[@]}"
            iptables $iptables_action INPUT "${xdmcp_port_rule[@]}"
        else
            return 1
        fi
    fi
}

xdmcp_security $1 >/dev/null 2>&1
