#!/bin/sh

if [ "`id -u`" != "0" ]; then
   #
   # Requires permission to access the XAUTHORITY file.
   #
   echo "`basename $0` must be executed as superuser"
   exit 1
fi

mPoint=""
lazy=""
force=""
while getopts m:fl arg
do
   case "$arg" in
   m)
      mPoint="$OPTARG";;
   f)
      force="-f";;
   l)
      lazy="-l";;
   esac
done

mountpoint "$mPoint" > /dev/null 2>&1
if [ "$?" != "0" ]; then
   echo "The target directory $mPoint is not a mountpoint"
   exit 2
fi

umount $force $lazy $mPoint > /dev/null 2>&1
if [ "$?" != "0" ]; then
   echo "UMount the target $mPoint failed"
   exit 3
fi

exit 0
