#!/bin/sh

###################################################
# Copyright 2015-2019 VMware, Inc.  All rights reserved.
###################################################


if [ "`id -u`" != "0" ]; then
   echo "StopUsbRedir.sh must be executed as superuser"
   exit 1
fi

#
# Main
#

#
# Include common constants
#
. "`dirname $0`/commonlib.sh"
define_constants

# Improve the robustness. Release the usbRedir resource.
startUsbRedirID="$(pidof -x StartUsbRedir.sh)"
if [ -n "$startUsbRedirID" ]; then
   echo "Kill the running StartUsbRedir.sh: $startUsbRedirID"
   kill -TERM $startUsbRedirID
   # Ensure the StartUsbRedir.sh exited.
   sleep 0.5
fi

usbRedirServerID="$(pidof usbRedirectionServer)"
if [ -n "$usbRedirServerID" ]; then
   echo "Kill the running usbRedirectionServer: $usbRedirServerID"
   kill -TERM $usbRedirServerID
   # Ensure the usbRedirectionServer exited.
   sleep 0.5
fi

if [ -S "/tmp/vvcProxy/vvcProxySocket" ]; then
   rm -f /tmp/vvcProxy/vvcProxySocket
fi

if [ -f "/tmp/vvcProxy/vvcProxyHubInited" ]; then
   rm -f /tmp/vvcProxy/vvcProxyHubInited
fi
