#!/bin/sh

###################################################
# Copyright 2019 VMware, Inc.  All rights reserved.
###################################################


if [ "`id -u`" != "0" ]; then
   echo "StopRdeServer.sh must be executed as superuser"
   exit 1
fi

#
# Main
#

#
# Include common constants
#
. "`dirname $0`/commonlib.sh"
define_constants

# Improve the robustness.
startRdeServerID="$(pidof -x StartRdeServer.sh)"
if [ -n "$startRdeServerID" ]; then
   echo "Kill the running StartRdeServer.sh: $startRdeServerID"
   kill -TERM $startRdeServerID
   # Ensure the StartRdeServer.sh exited.
   sleep 0.5
fi

rdeSvcID="$(pidof rdeSvc)"
if [ -n "$rdeSvcID" ]; then
   echo "Kill the running rdeSvc: $rdeSvcID"
   kill -TERM $rdeSvcID
   # Ensure the rdeSvc exited.
   sleep 0.5
fi

if [ -S "/tmp/vvcProxy/vvcProxySocket" ]; then
   rm -f /tmp/vvcProxy/vvcProxySocket
fi

if [ -f "/tmp/vvcProxy/vvcProxyHubInited" ]; then
   rm -f /tmp/vvcProxy/vvcProxyHubInited
fi
