#!/bin/sh

###################################################
# Copyright 2015-2019 VMware, Inc.  All rights reserved.
###################################################

trySleep=1.5
uemFile=

startVhciDriver() {
   echo "load the VHCI driver"

   lsmod | grep usb_vhci_iocifc > /dev/null 2>&1
   if [ "$?" != "0" ]; then
      if [ "$DISTRO_ID" = "$DISTRO_ID_SUSE" ]; then
         modprobe usb_vhci_iocifc --allow-unsupported > /dev/null 2>&1
      else
         modprobe usb_vhci_iocifc > /dev/null 2>&1
      fi
      if [ "$?" != "0" ]; then
         echo "VHCI driver isn't installed"
         exit 1
      fi
   fi

   local count=0;
   while [ "$count" -lt 5 ]; do
      if [ -e "/dev/usb-vhci" ]; then
         break
      fi

      sleep 0.5
      count=`expr $count + 1`
   done

   if [ ! -e "/dev/usb-vhci" ]; then
      echo "Load VHCI driver failed"
      exit 1
   fi
}

startUsbRedirServer() {
   echo "Invoke the usbRedirectionServer"
   exec $USBREDIR_SERVER ${uemFile} > /dev/null 2>&1
}

checkUsbRedirStatus() {
   local count=0;

   usbRedirPID=`pidof usbRedirectionServer`
   while [ "$usbRedirPID" = "" -a "$count" -lt 5 ]; do
      echo "Try to restart usbRedirectionServer `expr $count + 1` times"
      startUsbRedirServer
      sleep $trySleep
      usbRedirPID=`pidof usbRedirectionServer`
      count=`expr $count + 1`
   done

   if [ "$usbRedirPID" = "" ]; then
      echo "Failed to start usbRedirectionServer"
   fi
}

#
#================== main ==================
#

echo "StartUsbRedir.sh pid is: $$"

if [ "`id -u`" != "0" ]; then
   #
   # Requires permission to access VHCI driver.
   #
   echo "StartUsbRedir.sh must be executed as superuser"
   exit 1
fi

while getopts u: o
do
   case $o in
   u)
      uemFile="-u $OPTARG";;
   esac
done

#
# Prevent from the usbRedirectionServer launched duplicately
#
usbRedirID="$(pidof usbRedirectionServer)"
if [ -n "$usbRedirID" ]; then
   echo "Kill the running usbRedirectionServer: $usbRedirID"
   kill -TERM $usbRedirID
fi

#
# Include common constants
#
. "`dirname $0`/commonlib.sh"
define_constants
identify_distribution

if [ ! -f "$USBREDIR_SERVER" ]; then
   echo "The usbredir is not supported"
   exit 0
fi

while :
do
   if [ -f "/tmp/vvcProxy/vvcProxyHubInited${VMW_DESKTOP_ID}" ]; then
      break
   else
      sleep 0.5
   fi
done

#
# USB logger system need the USER macro.
#
export USER=root

#
# To avoid kernel accur 'page allocation failure', keep minimumreserved memory for kmalloc()
#
sysctl -w vm.min_free_kbytes=131072 > /dev/null 2>&1
sysctl -w vm.dirty_background_ratio=5 > /dev/null 2>&1
sysctl -w vm.dirty_ratio=10 > /dev/null 2>&1

startVhciDriver
startUsbRedirServer
