#!/bin/sh

###################################################
# Copyright 2019-2020 VMware, Inc.  All rights reserved.
###################################################

ssoTimeout=0


startRdeServer() {
   echo "Invoke the RDE server on display ${DISPLAY}, desktop ${VMW_DESKTOP_ID}"

   #
   # Disable window maximize/minimize animation, disable gnome screensaver
   # TODO: These settings are for metacity only, they don't work on RHEL7, need more investigation.
   #

   #gconftool-2 --direct --config-source xml:readwrite:/etc/gconf/gconf.xml.mandatory --type bool --set /apps/panel/global/enable_animations false
   #gconftool-2 --direct --config-source xml:readwrite:/etc/gconf/gconf.xml.mandatory --type bool --set /desktop/gnome/interface/accessibility true
   #gconftool-2 --direct --config-source xml:readwrite:/etc/gconf/gconf.xml.mandatory --type bool --set /apps/metacity/general/reduced_resources true
   #gconftool-2 --direct --config-source xml:readwrite:/etc/gconf/gconf.xml.mandatory --type bool --set /apps/gnome-screensaver/idle_activation_enabled false
   #gconftool-2 --direct --config-source xml:readwrite:/etc/gconf/gconf.xml.mandatory --type bool --set /apps/gnome-screensaver/lock_enabled false
   #gconftool-2 --direct --config-source xml:readwrite:/etc/gconf/gconf.xml.mandatory --type string --set /desktop/gnome/session/required_components/panel 'avant-window-navigator'

   #
   # TODO: LD_LIBRARY_PATH could be removed once add rpath option in the scons file.
   #
   export LD_LIBRARY_PATH=/usr/lib/vmware/viewagent/VVC/vchan_plugins/libs:$LD_LIBRARY_PATH

   #
   # Make sure Hub socket is ready, may be fixed in the future.
   #
   outofProcUds=/tmp/vvcProxy/vvcProxySocket${VMW_DESKTOP_ID}

   while :
   do
      if [ -e $outofProcUds ]; then
         echo "UDS $outofProcUds is ready"
         break
      else
         echo "UDS $outofProcUds not ready yet"
         sleep 0.5
      fi
   done

   XDG_CURRENT_DESKTOP=GNOME exec $RDE_SERVER -t "$ssoTimeout"
}

#
# Main
#

if [ "`id -u`" != "0" ]; then
   #
   # Requires permission to run usermod.
   #
   echo "StartRdeServer.sh must be executed as superuser"
   exit 1
fi

while getopts "t:" o
do
   case $o in
      t)
         ssoTimeout=${OPTARG}
         ;;
      *)
         echo "Invalid option: " $o
         ;;
   esac
done

echo "StartRdeServer.sh pid is: $$"

#
# Include common constants
#
. "`dirname $0`/commonlib.sh"
define_constants

if [ ! -f "$RDE_SERVER" ]; then
   echo "The rdeSvc is not installed on Agent"
   exit 0
fi

while :
do
   if [ -f "/tmp/vvcProxy/vvcProxyHubInited${VMW_DESKTOP_ID}" ]; then
      break
   else
      sleep 0.5
   fi
done

startRdeServer
