#!/bin/sh

###################################################
# Copyright 2018-2019 VMware, Inc.  All rights reserved.
###################################################

ret="1"
dbusAddrStr=""
user=""
magic=""
magicFile="/var/vmware/viewagent/ipc.magic"

if [ "`id -u`" != "0" ]; then
   #
   # Requires permission to access the XAUTHORITY file.
   #
   echo "StartCollabUI.sh must be executed as superuser"
   exit 1
fi

startCollabUI() {
   echo "Invoke the Collaboration UI"

   magic=$(cat $magicFile)
   envFile=${VIEWAGENT_TMP_ROOT}/view.${user}/envInfo

   for i in $(seq 10); do
      DBUS_ADDR_ENV_STR=$(grep "DBUS_SESSION_BUS_ADDRESS" ${envFile} 2>/dev/null)
      [ -n "${DBUS_ADDR_ENV_STR}" ] && break

      echo "Continue wait for environment variable DBUS_SESSION_BUS_ADDRESS ready"
      sleep 0.5
   done

   if [ -z ${DBUS_ADDR_ENV_STR} ]; then
      echo "Failed to get DBUS session address, can't start collabui"
      return
   else
      export "${DBUS_ADDR_ENV_STR}"
   fi

   interface="com.canonical.dbusmenu"
   member="LayoutUpdated"
   DBUS_CMD_STR="dbus-monitor --session \\ interface='$interface',member='$member'"
   su "$user" -c "$DBUS_CMD_STR > /tmp/collabui_dbus.txt &"

   # Pass magic via stdin
   su "$user" -c "echo $magic | $COLLABUI &"

   sleep 3

   uiId="$(pidof collabui)"
   count=0
   while [ -z "$uiId" -a $count -lt 10 ]; do
      echo "Restart collaboration UI"
      su "$user" -c "echo $magic | $COLLABUI &"
      sleep 3
      uiId="$(pidof collabui)"
      count=`expr $count + 1`
   done

   if [ -z "$uiId" -a $count -eq 10 ]; then
      echo "Failed to start collaboration UI"
   fi

   DBUS_CMD_STR="dbus-monitor --session  interface=$interface,member=$member"
   dbusMonitorID=`ps -ef | grep "$DBUS_CMD_STR" | grep -v grep | awk '{print $2}'`
   if [ -n "$dbusMonitorID" ]; then
      echo "Kill dbus-monitor for collabui: $dbusMonitorID"
      kill -TERM $dbusMonitorID
   fi

   number="$(grep 'horizon' /tmp/collabui_dbus.txt | wc -l)"
   echo "layoutUpdated $number times"
   if [ $number -lt '2' ]; then
      echo "Restart collaboration UI due to $number dbus session"
      collabuiID="$(pidof collabui)"
      kill -TERM $collabuiID
      su "$user" -c "echo $magic | $COLLABUI &"
   fi
   rm -f /tmp/collabui_dbus.txt

   ret=$?
}

while getopts u: o
do
   case $o in
   u)
      user="$OPTARG";;
   esac
done

#
# Prevent from the UI launched delicately
#
collabuiID="$(pidof collabui)"
count=0
while [ -n "$collabuiID" -a $count -lt 10 ]; do
   echo "Kill the running collabui: $collabuiID"
   kill -TERM $collabuiID
   sleep 1
   collabuiID="$(pidof collabui)"
   count=`expr $count + 1`
done

if [ -n "$collabuiID" -a $count -eq 10 ]; then
   echo "Failed to kill the running collabui: $collabuiID"
fi

#
# Include common constants
#
. "`dirname $0`/commonlib.sh"
define_constants

extract_X_args
startCollabUI

exit $ret
