#!/bin/sh

###################################################
# Copyright 2015-2019 VMware, Inc.  All rights reserved.
###################################################

configFile=
uemFile=
keyboardLayout=

echo "StartClipboard.sh pid is: $$"

if [ "`id -u`" != "0" ]; then
   #
   # Requires permission to access the XAUTHORITY file.
   #
   echo "StartClipboard.sh must be executed as superuser"
   exit 1
fi

#
# Include common constants
#
. "`dirname $0`/commonlib.sh"
define_constants

while getopts c:k:u: o
do
   case $o in
   c)
      configFile="-c $OPTARG";;
   k)
      keyboardLayout="$OPTARG";;
   u)
      uemFile="-u $OPTARG";;
   esac
done

# Some applications may reset the permission of XDG_RUNTIME_DIR.
# We should add the read and execute right here.
if [ -n "${XDG_RUNTIME_DIR}" ] && [ -d "${XDG_RUNTIME_DIR}" ]; then
   chmod g+rx ${XDG_RUNTIME_DIR}
fi

# Set keyboard layout here.
if [ -n "${keyboardLayout}" ]; then
   echo "Set keyboard layout to $keyboardLayout"
   setxkbmap $keyboardLayout
fi

if [ ! -f "$CLIPBOARD_SERVER" ]; then
   echo "The clipboard is not supported"
   exit 0
fi

while :
do
   if [ -f "/tmp/vvcProxy/vvcProxyHubInited${VMW_DESKTOP_ID}" ]; then
      break
   else
      sleep 0.5
   fi
done

exec $CLIPBOARD_SERVER ${configFile} ${uemFile} > /dev/null 2>&1
