#!/bin/sh

###################################################
# Copyright 2015-2019 VMware, Inc.  All rights reserved.
###################################################

account=
uemFile=
dropPri=

echo "StartCDRServer.sh pid is: $$"

if [ "`id -u`" != "0" ]; then
   #
   # Requires permission to access the XAUTHORITY file.
   #
   echo "StartCDRServer.sh must be executed as superuser"
   exit 1
fi

#
# Include common constants
#
. "`dirname $0`/commonlib.sh"
define_constants

while getopts c:u:d o
do
   case $o in
   c)
      uemFile="-c $OPTARG";;
   u)
      account="-u $OPTARG";;
   d)
      dropPri="-d";;
   esac
done

if [ ! -f "$CDR_SERVER" ]; then
   echo "The CDR is not supported"
   exit 0
fi

while :
do
   if [ -f "/tmp/vvcProxy/vvcProxyHubInited${VMW_DESKTOP_ID}" ]; then
      break
   else
      sleep 0.5
   fi
done

echo "will start CDR"

exec $CDR_SERVER ${account} ${uemFile} ${dropPri} > /dev/null 2>&1
