#!/bin/sh

###################################################
# Copyright 2015 - 2019 VMware, Inc.  All rights reserved.
###################################################

# Default Java binary

log_file=/var/log/vmware/viewagent-debug.log

start() {
    exec=/usr/lib/vmware/viewagent/jre/bin/java
    viewagent_path=/usr/lib/vmware/viewagent
    parameters=

    sh /usr/lib/vmware/viewagent/bin/CleanupTempFiles.sh
    sh /usr/lib/vmware/viewagent/bin/XorgConfigure.sh
    /bin/bash /usr/lib/vmware/viewagent/bin/ngvc-agent.sh
    cd /usr/lib/vmware/viewagent || exit

    if [ -f "/usr/lib/vmware/viewagent/java.security.txt" ]; then
       parameters="-Djava.security.properties=/usr/lib/vmware/viewagent/java.security.txt"
       exportsParameters="--add-exports java.base/sun.security.jca=ALL-UNNAMED --add-exports java.base/sun.security.internal.spec=ALL-UNNAMED"
    fi

    # Our X xerver should be started after the display manager is ready.
    # Currently, our X Server is based on the display manager enables
    # its XMDCP, so we can leverage the XDMCP state to detect the
    # display manager's state.
    timeout=15
    i=1
    echo "Waiting for display manager..." >> $log_file
    until [ $i -eq $timeout ]; do
      if lsof -i :xdmcp >/dev/null 2>&1
      then
         echo "Display manager is ready." >> $log_file
         break
      else
         sleep 1
      fi
      i=$(( $i+1 ))
    done

    if [ $i -eq $timeout ]
    then
       echo "Display manager is not ready after ${i}(s)." >> $log_file
       echo "Suggest to start/restart display manager(gdm/lighdm)." >> $log_file
    fi


    # destroy the old blastServer
    blastServerPid="$(pidof BlastServer)"
    [ -n "$blastServerPid" ] && kill -TERM $blastServerPid

    # destroy the old desktopDaemon
    desktopDaemonPid="$(pidof desktopDaemon)"
    [ -n "$desktopDaemonPid" ] && kill -TERM $desktopDaemonPid

    exec ${exec} -Dfile.encoding=UTF-8 -Djuds.folder.preferred=${viewagent_path} -showversion -Xmx512m -XX:+UseG1GC \
       ${BLAST_START_ATTEMPTS+-Dagent.blast.start.attempts=$BLAST_START_ATTEMPTS}  ${parameters} \
       ${exportsParameters} -cp "*:" com.vmware.vdi.agent.standalone.StandaloneAgent \
       -c /etc/vmware/viewagent-config.txt

    echo "agent service starting.." >> $log_file
    echo "network information" >> $log_file

    which ifconfig >/dev/null 2>&1
    if [ "$?" = "0" ]; then
       echo "$(ifconfig)" >> $log_file
    else
       which ip >/dev/null 2>&1 && echo "$(ip address)" >> $log_file
    fi
    echo >> $log_file
}

stop() {
    echo "`date` - Stopping viewagent service\n" >> $log_file
}

. "`dirname $0`/commonlib.sh"
define_constants

case "$1" in
    start|stop)
        "$(dirname $0)/XdmcpSecurity.sh" "$1"
        $1
        ;;
    *)
        echo $"Usage: $0 {start|stop}" >> $log_file
        exit 2
esac

