#!/bin/bash

###################################################
# Copyright 2017-2019 VMware, Inc.  All rights reserved.
###################################################

if [ "`id -u`" != "0" ]; then
   #
   # Requires root permission to run SsoConfigDesktopType.sh.
   #
   echo "SsoConfigDesktopType.sh must be executed as superuser"
   exit 1
fi

configure_desktop_type() {
   local ret=""
   type=`awk '/^SSODesktopType/{print}' ${CUSTOM_CFG_FILE} | cut -f2 -d"=" | tail -n1`
   if [ "$?" = "0" ] && [ ! -z "$type" ]; then
      case $type in
         "UseGnomeUbuntu")
            ret="ubuntu"
            ;;
         "UseMATE")
            ret="mate"
            ;;
         "UseKdePlasma")
            ret="1-kde-plasma-standard"
            [ "$DISTRO_ID" = "${DISTRO_ID_UBUNTU}" ] && [ "${OS_MAJOR}" = "18" ] && \
            ret="plasma"
            ;;
         "UseGnomeClassic")
            ret="gnome-classic"
            ;;
         *)
            ;;
      esac
   fi

   uid=`id -u $username` >/dev/null 2>&1
   if [ "$?" = "0" ] && [ ! -z "$ret" ]; then
       echo "Configuration $username ($uid) with desktop $ret"
       {
           # Ensure the Account's dbus interface is ready
           gdbus call --system --dest org.freedesktop.Accounts --object-path /org/freedesktop/Accounts --method org.freedesktop.Accounts.FindUserById "$uid"
           # Set the xsession type
           gdbus call --system --dest org.freedesktop.Accounts --object-path /org/freedesktop/Accounts/User${uid} --method org.freedesktop.Accounts.User.$1 "${ret}"
       } >/dev/null 2>&1
   fi
}

#
# Main
#
if [ "$#" != "1" ]; then
   echo "SsoConfigDesktopType.sh username"
   exit 1
fi
username="$1"

#
# Include common constants
#
. "`dirname $0`/commonlib.sh"
identify_distribution
define_constants

case "$DISTRO_ID" in
   ${DISTRO_ID_CENTOS} |\
   ${DISTRO_ID_RHEL_CLIENT} |\
   ${DISTRO_ID_RHEL_SERVER} |\
   ${DISTRO_ID_RHEL_WORKSTATION})
      if [ ${OS_MAJOR} = "7" ]; then
         configure_desktop_type SetXSession
      elif [ ${OS_MAJOR} = "8" ]; then
         configure_desktop_type SetSession
      fi
      ;;
   ${DISTRO_ID_UBUNTU})
      if [ ${OS_MAJOR} = "18" ]; then
         configure_desktop_type SetXSession
      fi
      ;;
   *)
      ;;
esac
