#!/bin/sh

###################################################
# Copyright 2017-2020 VMware, Inc.  All rights reserved.
###################################################

iconPath=""
xmlPath=""

extract_console_X_args() {
   local xpid
   local xcmd

   xpid="`pidof -s X`"
   [ "$?" = "0" ] || xpid="`pgrep -o Xorg`"
   [ "$?" = "0" ] && xcmd="`ps -p $xpid -o cmd --no-headers`" && \
                     parse_X_args $xcmd
   export DISPLAY=":0"
}

startappScanner() {
   # TODO: ensure the X args are from the X server started by OS.
   extract_console_X_args

   echo "Invoke the appScanner"
# AppScanner firstly used the script /usr/lib/vmware-tools/bin/xdg-find-menus
# to get the file /etc/xdg/menus/gnome-applications.menu and associated with
# .desktop files in /usr/share/applications to build the menu tree,then
# traverse the menu tree to get all the nodes(each node corresponding to an
# application) and populated them to the xml file. But it seems the glib
# gmenu-tree code can't parse the parameter "OnlyShowIn" corrrectly in
# .desktop file and can't build the correct tree on rhel76. With this
# environment variable set, the gmenu-tree code can work as expected.
   if [ $(echo $XDG_CURRENT_DESKTOP | grep "GNOME") ] ||
      [ "$XDG_CURRENT_DESKTOP" = "" ]; then
      export XDG_CURRENT_DESKTOP=GNOME
   fi
   export LD_LIBRARY_PATH=/usr/lib/vmware/viewagent/VVC/vchan_plugins/libs:$LD_LIBRARY_PATH
   $APPSCANNER -d $iconPath -f $xmlPath
   ret=$?
}

#
# Main
#

if [ "`id -u`" != "0" ]; then
   #
   # Requires permission to run usermod.
   #
   echo "RunappScanner.sh must be executed as superuser"
   exit 1
fi

while getopts "d:f:" o
do
   case $o in
   d)
      iconPath="$OPTARG";;
   f)
      xmlPath="$OPTARG";;
   esac
done

echo "RunappScanner.sh pid is: $$"

#
# Include common constants
#
. "`dirname $0`/commonlib.sh"

define_constants
startappScanner

exit $ret
