#!/bin/sh

###################################################
# Copyright 2019 VMware, Inc.  All rights reserved.
###################################################

WAIT_MAX=120
waitCount=0

if [ "`id -u`" != "0" ]; then
   echo "ResetDisplayManager.sh must be executed as superuser"
   exit 1
fi

#
# Main
#

#
# Include common constants
#
. "`dirname $0`/commonlib.sh"
identify_distribution
define_constants

#
# Enable core dumps
#
ulimit -c unlimited

display_manager_validity_check
if [ "$?" = "0" ]; then
   echo "Display manager is valid, not need to restart."
   exit 1
fi

echo "Begin to restart the display manager."
if grep systemd /proc/1/comm >/dev/null 2>&1; then
   echo "Restart the dispaly manager by systemd."
   systemctl retsart display-manager
elif ! service status gdm 2>&1 | grep -i "unrecognized" >/dev/null 2>&1; then
   echo "Restart GDM."
   service gdm restart
elif ! service status lightdm 2>&1 | grep -i "unrecognized" >/dev/null 2>&1; then
   echo "Restart lightdm."
   service lightdm restart
elif which -a initctl >/dev/null 2>&1 && initctl status prefdm >/dev/null 2>&1; then
   echo "Restart prefdm."
   initctl stop prefdm
   initctl start prefdm
else
   echo "Can not find the available display manager."
   exit 18
fi

while true
do
   display_manager_validity_check
   if  [ "$?" = "0" ]; then
      echo "Display manager restart successful."
      exit 0
   fi

   if [ $waitCount -lt $WAIT_MAX ]; then
      waitCount=`expr $waitCount + 1`
   else
      echo "Failed to restart display manager."
      exit 18
   fi

   sleep 1
done
