#!/bin/sh

########################################################
# Copyright 2019 VMware, Inc.  All rights reserved.
########################################################

keyboardLayout=

if [ "`id -u`" != "0" ]; then
   echo "PostLogin.sh must be executed as superuser"
   exit 1
fi

#
# Main
#

#
# Include common constants
#
. "`dirname $0`/commonlib.sh"
define_constants

while getopts k: o
do
   case $o in
   k)
      keyboardLayout="$OPTARG";;
   esac
done

# Set keyboard layout
if [ -n "${keyboardLayout}" ]; then
   echo "Set keyboard layout to ${keyboardLayout}."
   setxkbmap $keyboardLayout
fi

# Monitor Pulseaudio and set the pax11publish value.
exec /bin/sh /usr/lib/vmware/viewagent/bin/MonitorAudio.sh

