#!/bin/sh

options=""
device=""
mPoint=""
grab="no"

if [ "`id -u`" != "0" ]; then
   #
   # Requires permission to access the XAUTHORITY file.
   #
   echo "`basename $0` must be executed as superuser"
   exit 1
fi

while getopts o:d:m:g arg
do
   case "$arg" in
   o)
      options="-o $OPTARG";;
   d)
      device="$OPTARG";;
   m)
      mPoint="$OPTARG";;
   g)
      grab="yes";;
   esac
done

if [ ! -d "$mPoint" ]; then
   mkdir -p -m 600 "$mPoint" > /dev/null 2>&1
   if [ "$?" != "0" ]; then
      echo "Create the mount point directory $mPoint failed"
      exit 2
   fi
fi

mountpoint "$mPoint" > /dev/null 2>&1
if [ "$?" = "0" ]; then
   if [ "$grab" != "yes" ]; then
      echo "The directory $mPoint is a mountpoint already"
      exit 3
   else
      umount -f "$mPoint" > /dev/null 2>&1
      if [ "$?" != "0" ]; then
         echo "Umount the directory $mPoint failed"
         exit 4
      fi
   fi
fi

mount $options $device $mPoint > /dev/null 2>&1
if [ "$?" != "0" ]; then
   echo "Mount the source $device to the directory $mPoint failed"
   exit 5
fi

exit 0
