#!/bin/sh


AlarmHandler()
{
    echo "Got SIGALAM, user script execution took too long"
    KillSubProcs
    exit 14
}

KillSubProcs()
{
    kill $childPids
    if [ $? -eq 0 ];then
        echo "Sub-processes killed $childPids."
    fi
    kill $TIMERPROC
    if [ $? -eq 0 ];then
        echo "Timer-process killed $TIMERPROC."
    fi
}

SetTimer()
{
    DEF_TOUT=${1:-120};
    if [ $DEF_TOUT -ne 0 ];then
        sleep $DEF_TOUT > /dev/null 2>&1 && kill -s 14 > /dev/null 2>&1 $$ &
        TIMERPROC=$!
        echo "timer-process pid: $TIMERPROC"
    fi
}

UnsetTimer()
{
    echo "Unset timer"
    kill -9 $TIMERPROC > /dev/null 2>&1
    echo "timer killed.."
}


scriptFile=
hostName=
AGENT_CFG_FILE=/etc/vmware/viewagent-config.txt


#
# Monitor the change of host name
#

while getopts p:h:t: o
do
   case $o in
   p)
      scriptFile="$OPTARG"
      echo "customize script path: $scriptFile"
      ;;
   h)
      hostName="$OPTARG"
      echo "host name: $hostName"
      ;;
   t)
      timerInterval="$OPTARG"
      echo "timeout seconds: $timerInterval"
      ;;
   esac
done

# sleep to wait fullclone customization reboot
sleep 10s

while :
do
   newHostName=`hostname`
   if [ "$hostName" != "$newHostName" ]; then

      trap AlarmHandler 14

      # set the property RUNONCE to true in viewagent-config.txt
      prop=RUNONCE
      if [ -f "$AGENT_CFG_FILE" ]; then
         sed -i '/^'$prop'/d' $AGENT_CFG_FILE
         echo "$prop=true" >> $AGENT_CFG_FILE
      fi

      if [ -f $scriptFile ]; then
         echo "execute the user script"
         $scriptFile &
         childPids="$!"
         echo "user script process: $childPids"
         SetTimer $timerInterval
         echo "starting to wait the user script finished"
         wait $childPids
         echo "user script finished, return value is $?"
         UnsetTimer
      fi

      break
   fi

   sleep 1s
done

