#!/bin/sh

###################################################
# Copyright 2016-2019 VMware, Inc.  All rights reserved.
###################################################


if [ "`id -u`" != "0" ]; then
   #
   # Requires root permission to run GetMachineId.sh.
   #
   echo "GetMachineId.sh must be executed as superuser"
   exit 1
fi

logPath="/var/log/vmware/viewagent-debug.log"


need_update_dns() {
   ngaFork=`vmware-rpctool "info-get guestinfo.ngaFork"`
   if [ "$?" != "0" ]; then
      echo "`date`Command get guestinfo.ngaFork failed or guestinfo.ngaFork do not exist..." >> $logPath
      return 0
   fi

   forked=`vmware-rpctool "info-get guestinfo.forked"`
   if [ "$?" != "0" ]; then
      echo "`date` Command get guestinfo.forked failed or guestinfo.forked do not exist..." >> $logPath
      return 0
   fi

   if [ "$ngaFork" = "1" -a "$forked" = "1" ]; then
      domainJoinTool=`awk '/^OfflineJoinDomain/{print}' /etc/vmware/viewagent-custom.conf | cut -f2 -d"="`
      if [ "$domainJoinTool" = "samba" ]; then
         if [ "$DISTRO_ID" = ${DISTRO_ID_RHEL_WORKSTATION} ] && [ ${OS_MAJOR} -ge "8" ]; then
            needUpdateDns="yes"
         fi
      fi
   fi
}

update_dns_record() {
      echo "`date` Start updating dns record..." >> $logPath
      net ads dns register -P > /dev/null 2>&1
      if [ "$?" = "0" ]; then
         needUpdateDns="no"
      else
         echo "`date` dns record update failed..." >> $logPath
      fi
}


#
# Include common constants
#
. "`dirname $0`/commonlib.sh"
identify_distribution
define_constants

#
#Main
#

VIEWAGENT_PATH="/var/vmware/viewagent"
MACHINE_ID_FILE_PATH=$VIEWAGENT_PATH/machineId
RPCTOOL_PATH=`which vmware-rpctool`
touch $MACHINE_ID_FILE_PATH
chmod 640 $MACHINE_ID_FILE_PATH

# wait file monitor initialization
sleep 3s

while :
do
   if [ ! -x $VIEWAGENT_PATH ]; then
      sleep 20s
   else
      break
   fi
done

updateDnsTimes=0
needUpdateDns="no"

need_update_dns

while :
do

   machineid=`$RPCTOOL_PATH "machine.id.get"`
   if [ "$?" = "0" ]; then
      echo "$machineid" > $MACHINE_ID_FILE_PATH
   fi

   sleep 120s

   #
   # register dns record for instant clone samba offline domain join
   # update dns record will fail in CustomizateClonedMachined.sh during system startup
   # so update dns here and update only 3 times
   #
   if [ "${needUpdateDns}" = "yes" ]; then
      if [ $updateDnsTimes -lt 3 ]; then
         updateDnsTimes=`expr $i + 1`

         update_dns_record
      fi
   fi

done
