#!/bin/sh

###################################################
# Copyright 2019 VMware, Inc.  All rights reserved.
###################################################


if [ "`id -u`" != "0" ]; then
   #
   # Requires permission.
   #
   echo "GroupManager.sh must be executed as superuser"
   exit 1
fi

ADDGROUP=
cdrFolder=""
fuseKeyword="fuse.cdrserver"

while getopts u:a: o
do
   case $o in
   u)
      UserName="$OPTARG";;
   a)
      Action="$OPTARG";;
   esac
done

#
# Check if there is fuse group in the system, if no, create it.
#
which addgroup > /dev/null 2>&1
[ "$?" = "0" ] && [ ! -n "$ADDGROUP" ] && ADDGROUP=addgroup
which groupadd > /dev/null 2>&1
[ "$?" = "0" ] && [ ! -n "$ADDGROUP" ] && ADDGROUP=groupadd

if [ "$(getent group fuse)" != "0" ]; then
   $ADDGROUP --system fuse > /dev/null 2>&1
fi

#
# If the tsclient is already mounted, umount it.
#

cdrFolder=$(findmnt -t "$fuseKeyword" -u -n -O user_id=$(id -u "$UserName") -o TARGET)

if [ "$cdrFolder" != "" ]; then
   echo "Will unmount CDR folder $cdrFolder"
   fusermount -u -z "$cdrFolder" >/dev/null 2>&1
fi

if [ "$Action" = "Add" ]; then
   ret=`gpasswd -a $UserName fuse >/dev/null 2>&1`
elif [ "$Action" = "Remove" ]; then
   ret=`gpasswd -d $UserName fuse >/dev/null 2>&1`
fi

exit $ret
