#!/bin/bash

###################################################
# Copyright 2017-2020 VMware, Inc.  All rights reserved.
###################################################

ngvcAgentPrefix="`date` - [Customize-Machine-Script]"
logPath="/var/log/vmware/viewagent-ngvc.log"

restartWinbindService() {
   which winbindd > /dev/null 2>&1
   if [ "$?" = "0" ]; then
      echo "${ngvcAgentPrefix}: Begin to restart winbind." >> $logPath
      while true
      do
         service winbind restart
         sleep 10
         if service winbind status > /dev/null 2>&1 && wbinfo -P > /dev/null 2>&1
         then
            break
         fi
         echo "${ngvcAgentPrefix}: Try to restart winbind." >> $logPath
      done
      echo "${ngvcAgentPrefix}: End to restart winbind." >> $logPath
   fi
}

#
# Include common constants
#
. "`dirname $0`/commonlib.sh"
identify_distribution
define_constants

ngaFork=`vmware-rpctool "info-get guestinfo.ngaFork"`
if [ "$?" != "0" ]; then
   echo "${ngvcAgentPrefix}: Command get guestinfo.ngaFork failed or guestinfo.ngaFork do not exist..." >> $logPath
   return 0
fi

forked=`vmware-rpctool "info-get guestinfo.forked"`
if [ "$?" != "0" ]; then
   echo "${ngvcAgentPrefix}: Command get guestinfo.forked failed or guestinfo.forked do not exist..." >> $logPath
   return 0
fi

if [ "$ngaFork" = "1" -a "$forked" = "1" ]; then
   echo "${ngvcAgentPrefix}: Begin to customize cloned machine." >> $logPath
   domainJoinTool=`awk '/^OfflineJoinDomain/{print}' /etc/vmware/viewagent-custom.conf | cut -f2 -d"="`
   if [ "$domainJoinTool" = "samba" ]; then
      case "$DISTRO_ID" in
      ${DISTRO_ID_RHEL_CLIENT} |\
      ${DISTRO_ID_RHEL_SERVER} |\
      ${DISTRO_ID_RHEL_WORKSTATION})
         if [ ${OS_MAJOR} -ge "8" ]; then
            restartWinbindService
         fi
         ;;
      ${DISTRO_ID_UBUNTU})
         if [ ${OS_MAJOR} -ge "18" ]; then
            net ads changetrustpw
            restartWinbindService
         fi
         ;;
      esac

   elif [ "$domainJoinTool" = "pbis" ]; then
      which pbis > /dev/null 2>&1
      if [ "$?" = "0" ]; then
         echo "${ngvcAgentPrefix}: Begin to restart lwsmd." >> $logPath
         while true
         do
            echo "${ngvcAgentPrefix}: Try to restart lwsmd." >> $logPath
            service lwsmd restart
            sleep 5
            pbis status | grep -i Status | grep -i Online > /dev/null 2>&1
            if [ "$?" = "0" ]; then
               break
            fi
         done
         echo "${ngvcAgentPrefix}: End to restart lwsmd." >> $logPath

         fqdn=`vmware-rpctool "info-get guestinfo.primed.fqdn"`
         if [ "$?" = "0" ]; then
            typeset -u upFqdn
            if [ "$?" = "0" ]; then
               upFqdn="$fqdn"
            else
               upFqdn=$(echo -n "$fqdn" | tr 'a-z' 'A-Z')
            fi
            krb5Cache="/var/lib/pbis/krb5cc_lsass.$upFqdn"
            if [ -f $krb5Cache ]; then
               if [ ! -f /tmp/krb5cc_0 ]; then
                  ln -d $krb5Cache /tmp/krb5cc_0
               fi
               export KRB5CCNAME=$krb5Cache
            fi
         fi

         DNS_TOOL=/opt/pbis/bin/update-dns
         if [ -f $DNS_TOOL ]; then
            $DNS_TOOL --nocreds
            if [ "$?" != "0" ]; then
               hostName=`vmware-rpctool "info-get guestinfo.hostName"`
               $DNS_TOOL --nocreds --fqdn $hostName.$fqdn
               if [ "$?" != "0" ]; then
                  echo "${ngvcAgentPrefix}: Failed to update DNS." >> $logPath
               fi
            fi
         fi
      fi
   else
      echo "${ngvcAgentPrefix}: unknow offline join domain approach." >> $logPath
   fi
fi
