#!/bin/sh

###################################################
# Copyright 2019 VMware, Inc.  All rights reserved.
###################################################

sessionType=""
curTheme=""
expectedTheme=""

setTheme()
{
    gsettings set org.gnome.desktop.interface gtk-theme ${expectedTheme}
    if [ $? != 0 ]; then
        echo "Failed to set theme ${expectedTheme}"
    fi
}

getTheme()
{
    curTheme=`gsettings get org.gnome.desktop.interface gtk-theme`
    if [ $? != 0 ]; then
        echo "Failed to get theme"
    fi
}

while getopts t: o
do
    case $o in
    t)
        sessionType="${OPTARG}"
        ;;
    *)
        echo "Invalid options to configure theme"
        exit
    esac
done

if [ ${sessionType} = "application" ]; then
    expectedTheme="'VMWLight'"
else
    expectedTheme="'Adwaita'"
fi

getTheme
retry=0

while [ ${curTheme} != ${expectedTheme} ] && [ ${retry} -lt 10 ]; do
    setTheme
    sleep 1
    getTheme
    let retry+=1
done

echo "Finish activate theme ${expectedTheme}, tried ${retry} times"
