#!/bin/sh

###################################################
# Copyright 2015-2019 VMware, Inc.  All rights reserved.
###################################################

if [ "`id -u`" != "0" ]; then
   #
   # Requires permission to run CleanupTempFiles.sh.
   #
   echo "CleanupTempFiles.sh must be executed as superuser"
   exit 1
fi

#
# Include common functions
#
. "`dirname $0`/commonlib.sh"
define_constants

#
# Main
#

if [ -d $DESKTOP_TMP_PATH ]; then
    rm -rf $DESKTOP_TMP_PATH
fi

if [ -d $VIEWAGENT_TMP_PATH ]; then
    rm -rf $VIEWAGENT_TMP_PATH
fi

if [ -d $VIEWAGENT_TMP_ROOT ]; then
    chmod +t $VIEWAGENT_TMP_ROOT
else
    mkdir -p -m 1777 $VIEWAGENT_TMP_ROOT
fi

mkdir -p -m 755 $DESKTOP_TMP_PATH
chown root:root $DESKTOP_TMP_PATH

mkdir -p -m 700 $VIEWAGENT_TMP_PATH
chown vmwblast:vmwblast $VIEWAGENT_TMP_PATH

mkdir -m 700 $VIEWAGENT_TMP_PATH/screen
chown vmwblast:vmwblast $VIEWAGENT_TMP_PATH/screen
