#!/bin/sh

###################################################
# Copyright 2015-2020 VMware, Inc.  All rights reserved.
###################################################


logDir=`ls /tmp/ | grep vmware-`
logFile="vmware-MKSVchanServer vmware-vdpService-Server vmware-vvcProxy-Node vmware-mks vmware-apploader vmware-CDRServer vmware-UsbRedirPlugin vmware-UsbRedirServer vmware-RTAV vmware-DesktopWorker vmware-rdeSvc vmware-appScanner vmware-CDRServer vmware-DesktopController vmware-BlastProxy vmware-BlastServer vmware-DesktopDaemon"
OPT="c:"

# return 0: log file isn't using
# return 1: log file is using
log_file_check() {
   local logfile=$1
   if [ -f "$logfile" ]; then
      local substring=${logfile##*-}
      local logpid=${substring%.*}
      if [ -n $logpid ]; then
         if ps -p $logpid > /dev/null 2>&1
         then
            return 1
         fi
      fi
   fi

   return 0
}

# Parse option
while getopts $OPT o
do
   case "$o" in
   c)
      logCnt="$OPTARG";;
   *)
      exit;;
   esac
done

for f in $(find /tmp/ -name 'vmw-clean-log.*')
do
   if ps -p "${f#.}" -h -o 'comm' | grep "CleanupLogFiles.sh" >/dev/null 2>&1
   then
      echo "There's another one doing this job, do nothing."
      exit 0
   else
      rm -f $f
   fi
done

# Generate tmp file to record clean task
touch /tmp/vmw-clean-log.$$

# Cleanup log
if [ ${logCnt} -eq -1 ]; then
   echo "Keep all logs"
elif [ ${logCnt} -eq 0 ]; then
   echo "Remove all logs"

   for dir in $logDir; do
      for file in ${logFile}; do
         for f in `ls /tmp/${dir}/${file}-* 2>/dev/null`; do
            if log_file_check ${f}
            then
               rm -rf ${f}
            fi
         done
      done
   done
elif [ ${logCnt} -gt 0 ]; then
   echo "Reserve ${logCnt} logs"

   for dir in $logDir; do
      echo "Clean directory ${dir}"
      for file in ${logFile}; do

         logCount=`ls /tmp/${dir}/$file* 2>/dev/null | wc -l`

         if [ ${logCount} -gt ${logCnt} ]; then
            count=`expr ${logCount} - ${logCnt}`
            echo "Remove ${count} ${file} log(s)"
            for f in `ls -t /tmp/${dir}/${file}-* | tail -n ${count}`; do
               if log_file_check ${f}
               then
                  rm -rf ${f}
               fi
            done
         fi
      done
   done
else
   echo "Invalid log count: ${logCnt}"
fi

# Remove tmp file
rm -rf /tmp/vmw-clean-log.$$

