// -*- mode: js; js-indent-level: 4; indent-tabs-mode: nil -*-
//
//
// This file is created to group extra features for GNOME Shell needed by SLE
// Classic mode. A lot of features here are new or has large difference than
// original ones, so it might be cumbersome to make this a patch. Further, code
// here might under many changes, another reason for a separate file.
//
// This file should be installed in "%{_datadir}/gnome-shell/js/ui/" and used by
// "imports.ui.SLEClassicExt".

const Clutter = imports.gi.Clutter;
const GLib = imports.gi.GLib;
const Gtk = imports.gi.Gtk;
const Gio = imports.gi.Gio;
const Lang = imports.lang;
const Shell = imports.gi.Shell;
const Signals = imports.signals;
const St = imports.gi.St;
const Atk = imports.gi.Atk;

const BoxPointer = imports.ui.boxpointer;
const GrabHelper = imports.ui.grabHelper;
const Main = imports.ui.main;
const Params = imports.misc.params;
const Separator = imports.ui.separator;
const Slider = imports.ui.slider;
const Tweener = imports.ui.tweener;

const SLE_CLASSIC_SESSION_NAME = "sle-classic";

function isSLEClassicMode(){
    return (Main.sessionMode.currentMode === SLE_CLASSIC_SESSION_NAME);
}

// Smarter unicodeArrow, patch up popupMenu to replace the original
// unicodeArrow.
function smarterUnicodeArrow(side) {
    let arrowChar;
    // NOTE: only TOP and BOTTOM are affected by session
    let isAffectedBySession = false;

    switch (side) {
        case St.Side.TOP:
            isAffectedBySession = true;
            arrowChar = '\u25B4';
            break;
        case St.Side.RIGHT:
            arrowChar = '\u25B8';
            break;
        case St.Side.BOTTOM:
            isAffectedBySession = true;
            arrowChar = '\u25BE';
            break;
        case St.Side.LEFT:
            arrowChar = '\u25C2';
            break;
    }

    let arrowLable = new St.Label({ text: arrowChar,
                          style_class: 'unicode-arrow',
                          accessible_role: Atk.Role.ARROW,
                          y_expand: true,
                          y_align: Clutter.ActorAlign.CENTER });

    if ( isAffectedBySession ){
        arrowLable.connect('paint',
                           Lang.bind(arrowLable, (function(){
                               if ( isSLEClassicMode() ){
                                   this.set_text("\u25B4");
                               }
                               else {
                                   // none sle-classic
                                   this.set_text(arrowChar);
                               }
                           })));
    }

    return arrowLable;
}
