/*
 * Decompiled with CFR 0.152.
 */
package com.etsy.net;

import com.etsy.net.JUDS;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public abstract class UnixDomainSocket {
    private static final String LIB_TARGET = "juds.folder.preferred";
    private static File jarFile;
    protected UnixDomainSocketInputStream in;
    protected UnixDomainSocketOutputStream out;
    protected int nativeSocketFileHandle;
    protected String socketFile;
    protected int socketType;
    private int timeout;

    private static void getJarPath() {
        try {
            jarFile = new File(JUDS.jarURL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            UnixDomainSocket.throwLink(uRISyntaxException);
        }
    }

    private static void loadNativeLib() throws IOException {
        File file = UnixDomainSocket.getNativeLibTarget();
        if (!file.exists() || UnixDomainSocket.jarNewer(file).booleanValue()) {
            try {
                UnixDomainSocket.extractNativeLib(file);
                if (!file.exists()) {
                    UnixDomainSocket.throwLink("The native library was not extracted");
                }
            }
            catch (IOException iOException) {
                UnixDomainSocket.throwLink(iOException);
            }
            catch (URISyntaxException uRISyntaxException) {
                UnixDomainSocket.throwLink(uRISyntaxException);
            }
        }
        String string = "";
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            UnixDomainSocket.throwLink(iOException);
        }
        System.load(string);
    }

    private static Boolean jarNewer(File file) {
        return file.lastModified() < jarFile.lastModified();
    }

    private static void throwLink(Throwable throwable) {
        UnixDomainSocket.throwLink(throwable.toString());
    }

    private static void throwLink(String string) {
        throw new UnsatisfiedLinkError(string);
    }

    private static File getNativeLibTarget() throws IOException {
        File file;
        String string = UnixDomainSocket.platform();
        String string2 = "darwin".equals(string) ? "dylib" : "so";
        String string3 = System.getProperty(LIB_TARGET);
        if (string3 != null) {
            file = new File(string3);
            if (!file.isDirectory()) {
                throw new IOException("The preffered path is not a folder: " + file.getAbsolutePath());
            }
        } else {
            file = File.createTempFile("juds-temp", Long.toString(System.nanoTime()));
            if (!file.delete()) {
                throw new IOException("Could not delete temp file: " + file.getAbsolutePath());
            }
            if (!file.mkdir()) {
                throw new IOException("Could not create temp directory: " + file.getAbsolutePath());
            }
            file.deleteOnExit();
        }
        String string4 = String.format("libunixdomainsocket-%s-%s.%s", string, UnixDomainSocket.arch(), string2);
        File file2 = new File(file, string4);
        if (string3 == null) {
            file2.deleteOnExit();
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractNativeLib(File file) throws IOException, URISyntaxException {
        Object object;
        Closeable closeable;
        InputStream inputStream;
        String string = jarFile.getCanonicalPath() + "/" + file.getName();
        File file2 = new File(string);
        if (file2.exists()) {
            inputStream = new FileInputStream(file2);
        } else {
            closeable = new JarFile(jarFile);
            object = ((JarFile)closeable).getEntry(file.getName());
            if (object == null) {
                UnixDomainSocket.throwLink("Could not find library: " + file.getName());
            }
            inputStream = ((JarFile)closeable).getInputStream((ZipEntry)object);
        }
        try {
            closeable = new BufferedOutputStream(new FileOutputStream(file));
            try {
                int n;
                object = new byte[2048];
                while ((n = inputStream.read((byte[])object)) >= 0) {
                    ((OutputStream)closeable).write((byte[])object, 0, n);
                }
            }
            finally {
                ((OutputStream)closeable).close();
            }
        }
        finally {
            inputStream.close();
        }
    }

    private static String arch() {
        String string = System.getProperty("os.arch");
        if ("amd64".equals(string) || "x86_64".equals(string)) {
            return "x86_64";
        }
        return string;
    }

    private static String platform() {
        String string = System.getProperty("os.name").toLowerCase();
        if ("mac os x".equals(string)) {
            return "darwin";
        }
        return string;
    }

    protected static native int nativeCreate(String var0, int var1);

    protected static native int nativeListen(String var0, int var1, int var2);

    protected static native int nativeAccept(int var0, int var1);

    protected static native int nativeOpen(String var0, int var1);

    protected static native int nativeRead(int var0, byte[] var1, int var2, int var3);

    protected static native int nativeWrite(int var0, byte[] var1, int var2, int var3);

    protected static native int nativeTimeout(int var0, int var1);

    protected static native int nativeClose(int var0);

    protected static native int nativeCloseInput(int var0);

    protected static native int nativeCloseOutput(int var0);

    protected static native int nativeUnlink(String var0);

    protected UnixDomainSocket() {
    }

    protected UnixDomainSocket(int n, int n2) throws IOException {
        this.nativeSocketFileHandle = n;
        this.socketType = n2;
        this.socketFile = null;
        this.in = new UnixDomainSocketInputStream();
        if (this.socketType == 1) {
            this.out = new UnixDomainSocketOutputStream();
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    @Deprecated
    public void setTimeout(int n) {
        try {
            this.setSoTimeout(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Deprecated
    public int getTimeout() {
        return this.getSoTimeout();
    }

    public void setSoTimeout(int n) throws IOException {
        if (UnixDomainSocket.nativeTimeout(this.nativeSocketFileHandle, n) == -1) {
            throw new IOException("Unable to configure socket timeout");
        }
        this.timeout = n;
    }

    public int getSoTimeout() {
        return this.timeout;
    }

    public void close() {
        UnixDomainSocket.nativeClose(this.nativeSocketFileHandle);
    }

    public void unlink() {
        if (this.socketFile != null) {
            UnixDomainSocket.nativeUnlink(this.socketFile);
        }
    }

    static {
        UnixDomainSocket.getJarPath();
        try {
            UnixDomainSocket.loadNativeLib();
        }
        catch (IOException iOException) {
            UnixDomainSocket.throwLink(iOException);
        }
    }

    protected class UnixDomainSocketOutputStream
    extends OutputStream {
        protected UnixDomainSocketOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            if (UnixDomainSocket.nativeWrite(UnixDomainSocket.this.nativeSocketFileHandle, byArray, 0, 1) != 1) {
                throw new IOException("Unable to write to Unix domain socket");
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            if (UnixDomainSocket.nativeWrite(UnixDomainSocket.this.nativeSocketFileHandle, byArray, n, n2) != n2) {
                throw new IOException("Unable to write to Unix domain socket");
            }
        }

        @Override
        public void close() throws IOException {
            UnixDomainSocket.nativeCloseOutput(UnixDomainSocket.this.nativeSocketFileHandle);
        }
    }

    protected class UnixDomainSocketInputStream
    extends InputStream {
        protected UnixDomainSocketInputStream() {
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = UnixDomainSocket.nativeRead(UnixDomainSocket.this.nativeSocketFileHandle, byArray, 0, 1);
            if (n == -1) {
                throw new IOException();
            }
            return n > 0 ? byArray[0] & 0xFF : -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = UnixDomainSocket.nativeRead(UnixDomainSocket.this.nativeSocketFileHandle, byArray, n, n2);
            if (n3 == -1) {
                throw new IOException();
            }
            return n3 > 0 ? n3 : -1;
        }

        @Override
        public void close() throws IOException {
            UnixDomainSocket.nativeCloseInput(UnixDomainSocket.this.nativeSocketFileHandle);
        }
    }
}

